/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.listener;

import cn.gitlab.kilo.jetbrains.common.ExtensionMessage;
import cn.gitlab.kilo.jetbrains.common.TextDocumentVisibleChangedEvent;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"setCurrentSelectedFile", "", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
public final class MyEditorListenerKt {
    public static final void setCurrentSelectedFile(@NotNull Project project) {
        VirtualFile activeFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = manager.getSelectedEditor();
        Object object = activeFile = fileEditor != null ? fileEditor.getFile() : null;
        if (activeFile == null || activeFile.getFileType().isBinary()) {
            ThemeUtilKt.sendToWebview((ExtensionMessage)new TextDocumentVisibleChangedEvent("textDocumentVisibleChanged", "", "", ""), project);
            return;
        }
        try {
            String string;
            String fileContent;
            block9: {
                block8: {
                    byte[] byArray = activeFile.contentsToByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
                    byte[] byArray2 = byArray;
                    Charset charset = Charsets.UTF_8;
                    fileContent = new String(byArray2, charset);
                    if (fileContent.length() >= 0x100000) {
                        return;
                    }
                    string = project.getBasePath();
                    if (string == null) break block8;
                    String basePath = string;
                    boolean bl = false;
                    String string2 = activeFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    String string3 = StringsKt.removePrefix((String)string2, (CharSequence)(basePath + "/"));
                    string = string3;
                    if (string3 != null) break block9;
                }
                string = "Unknown Relative Path";
            }
            String relativePath = string;
            String string4 = activeFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
            ThemeUtilKt.sendToWebview((ExtensionMessage)new TextDocumentVisibleChangedEvent("textDocumentVisibleChanged", string4, fileContent, relativePath), project);
        }
        catch (FileTooBigException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

