/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.factories;

import cn.gitlab.kilo.jetbrains.factories.ResourceHandlerState;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cef.callback.CefCallback;
import org.cef.handler.CefLoadHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcn/gitlab/kilo/jetbrains/factories/OpenedConnection;", "Lcn/gitlab/kilo/jetbrains/factories/ResourceHandlerState;", "connection", "Ljava/net/URLConnection;", "<init>", "(Ljava/net/URLConnection;)V", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "inputStream$delegate", "Lkotlin/Lazy;", "getResponseHeaders", "", "cefResponse", "Lorg/cef/network/CefResponse;", "responseLength", "Lorg/cef/misc/IntRef;", "redirectUrl", "Lorg/cef/misc/StringRef;", "readResponse", "", "dataOut", "", "bytesToRead", "", "bytesRead", "callback", "Lorg/cef/callback/CefCallback;", "close", "coderider-kilo-jetbrains"})
public final class OpenedConnection
extends ResourceHandlerState {
    @Nullable
    private final URLConnection connection;
    @NotNull
    private final Lazy inputStream$delegate;

    public OpenedConnection(@Nullable URLConnection connection) {
        super(null);
        this.connection = connection;
        this.inputStream$delegate = LazyKt.lazy(() -> OpenedConnection.inputStream_delegate$lambda$0(this));
    }

    private final InputStream getInputStream() {
        Lazy lazy = this.inputStream$delegate;
        return (InputStream)lazy.getValue();
    }

    @Override
    public void getResponseHeaders(@NotNull CefResponse cefResponse, @NotNull IntRef responseLength, @NotNull StringRef redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)cefResponse, (String)"cefResponse");
        Intrinsics.checkNotNullParameter((Object)responseLength, (String)"responseLength");
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        try {
            if (this.connection != null) {
                String string = this.connection.getURL().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String url = string;
                if (this.connection.getContentType() == null) {
                    if (StringsKt.contains$default((CharSequence)url, (CharSequence)".css", (boolean)false, (int)2, null)) {
                        cefResponse.setMimeType("text/css");
                    } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)".js", (boolean)false, (int)2, null)) {
                        cefResponse.setMimeType("text/javascript");
                    } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)".html", (boolean)false, (int)2, null)) {
                        cefResponse.setMimeType("text/html");
                    } else {
                        cefResponse.setMimeType(this.connection.getContentType());
                    }
                } else {
                    cefResponse.setMimeType(this.connection.getContentType());
                }
                InputStream inputStream = this.getInputStream();
                responseLength.set(inputStream != null ? inputStream.available() : 0);
                cefResponse.setStatus(200);
            } else {
                cefResponse.setError(CefLoadHandler.ErrorCode.ERR_FAILED);
                cefResponse.setStatusText("Connection is null");
                cefResponse.setStatus(500);
            }
        }
        catch (IOException e) {
            cefResponse.setError(CefLoadHandler.ErrorCode.ERR_FILE_NOT_FOUND);
            cefResponse.setStatusText(e.getLocalizedMessage());
            cefResponse.setStatus(404);
        }
    }

    @Override
    public boolean readResponse(@NotNull byte[] dataOut, int bytesToRead, @NotNull IntRef bytesRead, @NotNull CefCallback callback) {
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        Intrinsics.checkNotNullParameter((Object)bytesRead, (String)"bytesRead");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            boolean bl;
            InputStream inputStream2 = inputStream;
            boolean bl2 = false;
            int availableSize = inputStream2.available();
            if (availableSize > 0) {
                int maxBytesToRead = Math.min(availableSize, bytesToRead);
                int realBytesRead = inputStream2.read(dataOut, 0, maxBytesToRead);
                bytesRead.set(realBytesRead);
                bl = true;
            } else {
                inputStream2.close();
                bl = false;
            }
            return bl;
        }
        return false;
    }

    @Override
    public void close() {
        block0: {
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) break block0;
            inputStream.close();
        }
    }

    private static final InputStream inputStream_delegate$lambda$0(OpenedConnection this$0) {
        URLConnection uRLConnection = this$0.connection;
        return uRLConnection != null ? uRLConnection.getInputStream() : null;
    }
}

