/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.editor.settings;

import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.client.KnowledgeBaseCreateReq;
import cn.gitlab.kilo.jetbrains.client.KnowledgeBaseNameUpdateReq;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.KBType;
import com.google.gson.JsonObject;
import java.util.Collection;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcn/gitlab/kilo/jetbrains/editor/settings/RagManager;", "", "<init>", "()V", "showErrorMessage", "", "message", "", "type", "", "showInfoMessage", "title", "terminateKnowledgeBase", "kbProjectId", "renameKnowledgeBase", "", "req", "Lcom/google/gson/JsonObject;", "updateKnowledgeBase", "deleteKnowledgeBase", "createKnowledgeBase", "Lcn/gitlab/kilo/jetbrains/client/KnowledgeBaseCreateReq;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nRagManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RagManager.kt\ncn/gitlab/kilo/jetbrains/editor/settings/RagManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class RagManager {
    private final void showErrorMessage(String message, int type2) {
        JOptionPane.showMessageDialog(null, message, I18nKt.getMessage("error"), type2);
    }

    static /* synthetic */ void showErrorMessage$default(RagManager ragManager, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        ragManager.showErrorMessage(string, n);
    }

    private final void showInfoMessage(String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 1);
    }

    public final void terminateKnowledgeBase(@NotNull String kbProjectId) {
        Intrinsics.checkNotNullParameter((Object)kbProjectId, (String)"kbProjectId");
        try {
            CoderiderClient.TerminateResponse response = CoderiderClientKt.getCoderiderClient().terminateKnowledgeBase(kbProjectId);
            if (!((Collection)response.getTerminated()).isEmpty() || !((Collection)response.getRevoked()).isEmpty()) {
                CoderiderClientKt.getCoderiderClient().syncRagConfig();
            } else {
                RagManager.showErrorMessage$default(this, I18nKt.getMessage("failed_to_cancel_creation"), 0, 2, null);
            }
        }
        catch (Exception e) {
            RagManager.showErrorMessage$default(this, I18nKt.getMessage("failed_to_cancel_creation") + ": " + e.getMessage(), 0, 2, null);
        }
    }

    public final boolean renameKnowledgeBase(@NotNull JsonObject req) {
        Object object;
        Object $this$renameKnowledgeBase_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Object object2 = this;
        try {
            $this$renameKnowledgeBase_u24lambda_u240 = object2;
            boolean bl = false;
            CharSequence charSequence = req.get("name").getAsString();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return false;
            }
            CoderiderClient coderiderClient = CoderiderClientKt.getCoderiderClient();
            String string = req.get("kb_project_id").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            coderiderClient.updateKnowledgeBaseName(new KnowledgeBaseNameUpdateReq(string, req.get("name").getAsString()));
            CoderiderClientKt.getCoderiderClient().syncRagConfig();
            $this$renameKnowledgeBase_u24lambda_u240 = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            $this$renameKnowledgeBase_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$renameKnowledgeBase_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            RagManager.showErrorMessage$default(this, I18nKt.getMessage("update_knowledge_base_failed"), 0, 2, null);
            object = false;
        }
        return (Boolean)object;
    }

    public final boolean updateKnowledgeBase(@NotNull String kbProjectId) {
        Object object;
        Object $this$updateKnowledgeBase_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)kbProjectId, (String)"kbProjectId");
        Object object2 = this;
        try {
            $this$updateKnowledgeBase_u24lambda_u242 = object2;
            boolean bl = false;
            CoderiderClientKt.getCoderiderClient().updateKnowledgeBase(kbProjectId);
            CoderiderClientKt.getCoderiderClient().syncRagConfig();
            $this$updateKnowledgeBase_u24lambda_u242 = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            $this$updateKnowledgeBase_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$updateKnowledgeBase_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            this.showErrorMessage(I18nKt.getMessage("update_knowledge_base_failed") + " message: " + e.getMessage(), 2);
            object = false;
        }
        return (Boolean)object;
    }

    public final boolean deleteKnowledgeBase(@NotNull String kbProjectId) {
        Object object;
        Object $this$deleteKnowledgeBase_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)kbProjectId, (String)"kbProjectId");
        Object object2 = this;
        try {
            $this$deleteKnowledgeBase_u24lambda_u244 = object2;
            boolean bl = false;
            CoderiderClientKt.getCoderiderClient().deleteKnowledgeBase(kbProjectId);
            CoderiderClientKt.getCoderiderClient().syncRagConfig();
            super.showInfoMessage(I18nKt.getMessage("knowledge_base_deleted_successfully"), I18nKt.getMessage("deletion_successful"));
            $this$deleteKnowledgeBase_u24lambda_u244 = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            $this$deleteKnowledgeBase_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$deleteKnowledgeBase_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            RagManager.showErrorMessage$default(this, I18nKt.getMessage("failed_to_delete_knowledge_base") + ": " + e.getMessage(), 0, 2, null);
            object = false;
        }
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean createKnowledgeBase(@NotNull KnowledgeBaseCreateReq req) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object $this$createKnowledgeBase_u24lambda_u248;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Object object5 = this;
        try {
            Object object6;
            Object object7;
            Object it;
            $this$createKnowledgeBase_u24lambda_u248 = object5;
            boolean bl = false;
            object4 = new KBType[]{KBType.filebase, KBType.codebase};
            KBType[] kbTypes = object4;
            if (!ArraysKt.contains((Object[])kbTypes, (Object)((Object)req.getKbType())) || ((CharSequence)req.getUrl()).length() == 0) {
                return false;
            }
            Object object8 = req;
            String string = req.getRef();
            if (string != null) {
                Object object9 = object3 = string;
                object2 = object8;
                boolean bl2 = false;
                object8 = object2;
                object7 = Boolean.valueOf(!StringsKt.isBlank((CharSequence)((CharSequence)it))).booleanValue() ? object3 : null;
            } else {
                object7 = null;
            }
            ((KnowledgeBaseCreateReq)object8).setRef((String)object7);
            Object object10 = req;
            String string2 = req.getName();
            if (string2 != null) {
                it = object3 = string2;
                object2 = object10;
                boolean bl3 = false;
                object10 = object2;
                object6 = Boolean.valueOf(!StringsKt.isBlank((CharSequence)((CharSequence)it))).booleanValue() ? object3 : null;
            } else {
                object6 = null;
            }
            ((KnowledgeBaseCreateReq)object10).setName((String)object6);
            CoderiderClientKt.getCoderiderClient().createKnowledgeBase(req);
            CoderiderClientKt.getCoderiderClient().syncRagConfig();
            $this$createKnowledgeBase_u24lambda_u248 = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            $this$createKnowledgeBase_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object5 = $this$createKnowledgeBase_u24lambda_u248;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object5);
        if (throwable == null) {
            object = object5;
        } else {
            String string;
            Throwable e = throwable;
            boolean bl = false;
            RagManager ragManager = this;
            String string3 = I18nKt.getMessage("create_knowledge_base_failed");
            String string4 = e.getMessage();
            if (string4 != null) {
                void it;
                object4 = string4;
                String string5 = string3;
                object3 = ragManager;
                boolean bl4 = false;
                object2 = I18nKt.getDirectTranslation((String)it);
                ragManager = object3;
                string3 = string5;
                string = object2;
            } else {
                string = null;
            }
            ragManager.showErrorMessage(string3 + ":" + string, 2);
            object = false;
        }
        return (Boolean)object;
    }
}

