/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.lenses;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.edit.LensesService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B-\u0012$\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R/\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/lenses/LensEditAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "editAction", "Lkotlin/Function4;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Lcom/intellij/openapi/editor/Editor;", "", "", "<init>", "(Lkotlin/jvm/functions/Function4;)V", "getEditAction", "()Lkotlin/jvm/functions/Function4;", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "event", "actionPerformed", "e", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nLensEditAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LensEditAction.kt\ncn/gitlab/kilo/jetbrains/edit/lenses/LensEditAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public abstract class LensEditAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function4<Project, AnActionEvent, Editor, String, Unit> editAction;
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String TASK_ID_KEY = "TASK_ID_KEY";

    public LensEditAction(@NotNull Function4<? super Project, ? super AnActionEvent, ? super Editor, ? super String, Unit> editAction) {
        Intrinsics.checkNotNullParameter(editAction, (String)"editAction");
        this.editAction = editAction;
        this.logger = Logger.Companion.getInstance(LensEditAction.class);
    }

    @NotNull
    public final Function4<Project, AnActionEvent, Editor, String, Unit> getEditAction() {
        return this.editAction;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        try {
            String taskId;
            Project project = e.getProject();
            if (project == null || project.isDisposed()) {
                Logger.warn$default(this.logger, "Received code lens action for null or disposed project: " + e, null, 2, null);
                return;
            }
            Editor editor = (Editor)e.getDataContext().getData(PlatformDataKeys.EDITOR);
            if (editor == null || editor.isDisposed()) {
                Logger.warn$default(this.logger, "Received code lens action for null or disposed editor: " + e, null, 2, null);
                return;
            }
            String string = taskId = LensesService.Companion.getInstance(project).getTaskIdsOfFirstVisibleLens(editor);
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.editAction.invoke((Object)project, (Object)e, (Object)editor, (Object)it);
            }
        }
        catch (Exception ex) {
            Logger.warn$default(this.logger, "Error accepting edit accept task: " + ex, null, 2, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/lenses/LensEditAction$Companion;", "", "<init>", "()V", "TASK_ID_KEY", "", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

