/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.action;

import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.edit.CockpitInlineQuickCommandRenderKt;
import cn.gitlab.kilo.jetbrains.edit.EditInlineStreamService;
import cn.gitlab.kilo.jetbrains.edit.EditStreamHandler;
import cn.gitlab.kilo.jetbrains.edit.action.DiffStreamUtilsKt;
import cn.gitlab.kilo.jetbrains.edit.action.InlineActionHelperKt;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/action/UnitTestAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "handleGenerateTests", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nUnitTestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitTestAction.kt\ncn/gitlab/kilo/jetbrains/edit/action/UnitTestAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,79:1\n31#2,2:80\n*S KotlinDebug\n*F\n+ 1 UnitTestAction.kt\ncn/gitlab/kilo/jetbrains/edit/action/UnitTestAction\n*L\n70#1:80,2\n*E\n"})
public final class UnitTestAction
extends AnAction {
    public UnitTestAction() {
        super("CodeRider-Kilo\uff1a" + I18nKt.getMessage("quick.command.test"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        this.handleGenerateTests(editor2, project2);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (CockpitConfiguration.Companion.getInstance().needLogin()) {
            presentation2.setEnabledAndVisible(false);
        } else {
            presentation2.setEnabledAndVisible(true);
        }
        e.getPresentation().setEnabled(e.getPresentation().isEnabled() && !InlineActionHelperKt.isReadOnly(e));
    }

    private final void handleGenerateTests(Editor editor, Project project) {
        TrackService.commandUsage$default(TrackService.INSTANCE, null, CoderiderTrackClient.CommandType.generate_test, 1, null);
        VirtualFile virtualFile = editor.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        String string2 = virtualFile2.getFileType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String language = string2;
        String string3 = editor.getSelectionModel().getSelectedText();
        if (string3 == null) {
            string3 = "";
        }
        String selectedText = string3;
        String string4 = I18nKt.getInlinePrompt("prompt.generate.test");
        Object[] objectArray = new Object[]{filePath, language, selectedText};
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        String prompt = string5;
        CockpitInlineQuickCommandRenderKt.createTestFileNameSafe(project, virtualFile2, filePath, (Function1<? super String, Unit>)((Function1)arg_0 -> UnitTestAction.handleGenerateTests$lambda$0(project, editor, prompt, arg_0)));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final Unit handleGenerateTests$lambda$0(Project $project, Editor $editor, String $prompt, String newFile) {
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        boolean fileExists = CockpitInlineQuickCommandRenderKt.fileExists(newFile);
        Editor editor = !fileExists ? CockpitInlineQuickCommandRenderKt.createNewFileEditor($project, newFile) : CockpitInlineQuickCommandRenderKt.createTemporaryVirtualFileAndOpen$default($project, newFile, null, 4, null);
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor newEditor = editor;
        EditStreamHandler handler = !fileExists ? DiffStreamUtilsKt.generateDiffStreamHandler($editor, $project, newEditor, 0) : DiffStreamUtilsKt.generateNewFileDiffStreamHandler($editor, $project, newEditor, newFile);
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((EditInlineStreamService)object).register(handler, newEditor);
        handler.streamDiffLinesToEditor($prompt, false, true, true);
        return Unit.INSTANCE;
    }
}

