/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.edit.EditStreamHandlerKt;
import cn.gitlab.kilo.jetbrains.edit.EditorComponentInlaysManager;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.utils.UpdateFileSilentUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ApplicationKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010$\u001a\u00020\u000bJ\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0007J\u001e\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\nJ\u0006\u0010+\u001a\u00020\u000bJ\u0006\u0010,\u001a\u00020\u000bJ\b\u0010-\u001a\u00020\u000bH\u0002J\b\u0010.\u001a\u00020\u000bH\u0002J\u0006\u0010/\u001a\u00020\u000bJ\u0006\u00100\u001a\u00020\u000bJ\b\u00101\u001a\u00020\u000bH\u0002J\b\u00102\u001a\u00020\u000bH\u0002J\b\u00103\u001a\u00020\u000bH\u0002J\u0010\u00104\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/VerticalDiffBlock;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "startLine", "", "onAcceptReject", "Lkotlin/Function2;", "", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;ILkotlin/jvm/functions/Function2;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getStartLine", "()I", "setStartLine", "(I)V", "deletedLines", "", "", "getDeletedLines", "()Ljava/util/List;", "addedLines", "getAddedLines", "deletionInlay", "Lcom/intellij/openapi/Disposable;", "textArea", "Ljavax/swing/JTextArea;", "hasRenderedDiffBlock", "editorComponentInlaysManager", "Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager;", "greenKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "clearEditorUI", "updatePosition", "newLineNumber", "addNewLine", "text", "line", "isFinal", "onLastDiffLine", "handleReject", "refreshEditor", "renderDeletedLinesInlay", "accept", "reject", "handleAccept", "revertDiff", "removeGreenHighlighters", "createDeletionTextArea", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nVerticalDiffBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalDiffBlock.kt\ncn/gitlab/kilo/jetbrains/edit/VerticalDiffBlock\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n3829#2:165\n4344#2,2:166\n1869#3,2:168\n*S KotlinDebug\n*F\n+ 1 VerticalDiffBlock.kt\ncn/gitlab/kilo/jetbrains/edit/VerticalDiffBlock\n*L\n145#1:165\n145#1:166,2\n150#1:168,2\n*E\n"})
public final class VerticalDiffBlock {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    private int startLine;
    @NotNull
    private final Function2<VerticalDiffBlock, Boolean, Unit> onAcceptReject;
    @NotNull
    private final List<String> deletedLines;
    @NotNull
    private final List<String> addedLines;
    @Nullable
    private Disposable deletionInlay;
    @Nullable
    private JTextArea textArea;
    private boolean hasRenderedDiffBlock;
    @NotNull
    private final EditorComponentInlaysManager editorComponentInlaysManager;
    @NotNull
    private final TextAttributesKey greenKey;

    public VerticalDiffBlock(@NotNull Editor editor, @NotNull Project project, int startLine, @NotNull Function2<? super VerticalDiffBlock, ? super Boolean, Unit> onAcceptReject) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onAcceptReject, (String)"onAcceptReject");
        this.editor = editor;
        this.project = project;
        this.startLine = startLine;
        this.onAcceptReject = onAcceptReject;
        this.deletedLines = new ArrayList();
        this.addedLines = new ArrayList();
        this.editorComponentInlaysManager = EditorComponentInlaysManager.Companion.from(this.editor, false);
        this.greenKey = EditStreamHandlerKt.createTextAttributesKey("CONTINUE_DIFF_NEW_LINE", 0x3000FF00, this.editor);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final void setStartLine(int n) {
        this.startLine = n;
    }

    @NotNull
    public final List<String> getDeletedLines() {
        return this.deletedLines;
    }

    @NotNull
    public final List<String> getAddedLines() {
        return this.addedLines;
    }

    public final void clearEditorUI() {
        Disposable disposable = this.deletionInlay;
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            if (ApplicationKt.getApplication().isDispatchThread()) {
                it.dispose();
            } else {
                ActionsKt.invokeLater$default(null, () -> VerticalDiffBlock.clearEditorUI$lambda$1$lambda$0(it), (int)1, null);
            }
        }
        this.removeGreenHighlighters();
    }

    public final void updatePosition(int newLineNumber) {
        this.startLine = newLineNumber;
        this.refreshEditor();
    }

    public final void addNewLine(@NotNull String text, int line, boolean isFinal) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int safeLine = Math.max(Math.min(line, document2.getLineCount() - 1), 0);
        int offset = document2.getLineStartOffset(safeLine);
        UpdateFileSilentUtilsKt.insertString(document2, offset, text + (isFinal ? "" : "\n"));
        boolean bl = 0 <= safeLine ? safeLine < document2.getLineCount() : false;
        if (bl) {
            this.editor.getMarkupModel().addLineHighlighter(this.greenKey, safeLine, 6000);
        }
        this.addedLines.add(text);
    }

    public final void onLastDiffLine() {
        if (this.hasRenderedDiffBlock) {
            return;
        }
        if (this.deletedLines.size() > 0) {
            this.renderDeletedLinesInlay();
        }
        this.hasRenderedDiffBlock = true;
    }

    public final void handleReject() {
        this.revertDiff();
        this.clearEditorUI();
    }

    private final void refreshEditor() {
        this.editor.getContentComponent().revalidate();
        this.editor.getContentComponent().repaint();
    }

    private final void renderDeletedLinesInlay() {
        Disposable disposable;
        JTextArea textArea;
        this.textArea = textArea = this.createDeletionTextArea(CollectionsKt.joinToString$default((Iterable)this.deletedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        this.deletionInlay = disposable = this.editorComponentInlaysManager.insert(this.startLine, textArea, true);
    }

    public final void accept() {
        CoderiderTrackClient.INSTANCE.recordAICodeGenerationEvent(CoderiderTrackClient.SceneType.INLINE, CollectionsKt.joinToString$default((Iterable)this.addedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null).length(), ModelsConfiguration.Companion.getInstance().getDefaultChatModel().getKey());
        CoderiderTrackClient.INSTANCE.recordAICodeSuggestionAdoptEvent(CoderiderTrackClient.SceneType.INLINE, 1, StringsKt.lines((CharSequence)CollectionsKt.joinToString$default((Iterable)this.addedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).size(), ModelsConfiguration.Companion.getInstance().getDefaultChatModel().getKey());
    }

    public final void reject() {
        this.handleReject();
        this.onAcceptReject.invoke((Object)this, (Object)false);
    }

    private final void handleAccept() {
        this.clearEditorUI();
    }

    private final void revertDiff() {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> VerticalDiffBlock.revertDiff$lambda$2(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void removeGreenHighlighters() {
        void $this$filterTo$iv$iv;
        RangeHighlighter[] rangeHighlighterArray = this.editor.getMarkupModel().getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$filter$iv = rangeHighlighterArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighter highlighter = (RangeHighlighter)element$iv$iv;
            boolean bl = false;
            int highlighterLine = this.editor.getDocument().getLineNumber(highlighter.getStartOffset());
            int n = this.startLine;
            boolean bl2 = highlighterLine < this.startLine + this.addedLines.size() ? n <= highlighterLine : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List highlightersToRemove = (List)destination$iv$iv;
        Iterable $this$forEach$iv = highlightersToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            this.editor.getMarkupModel().removeHighlighter(it);
        }
    }

    private final JTextArea createDeletionTextArea(String text) {
        JTextArea jTextArea;
        JTextArea $this$createDeletionTextArea_u24lambda_u245 = jTextArea = new JTextArea(text);
        boolean bl = false;
        $this$createDeletionTextArea_u24lambda_u245.setEditable(false);
        $this$createDeletionTextArea_u24lambda_u245.setBackground((Color)new JBColor(0x30FF0000, 0x30FF0000));
        $this$createDeletionTextArea_u24lambda_u245.setForeground((Color)JBColor.GRAY);
        $this$createDeletionTextArea_u24lambda_u245.setBorder(BorderFactory.createEmptyBorder());
        $this$createDeletionTextArea_u24lambda_u245.setLineWrap(false);
        $this$createDeletionTextArea_u24lambda_u245.setWrapStyleWord(false);
        $this$createDeletionTextArea_u24lambda_u245.setFont(this.editor.getColorsScheme().getFont(EditorFontType.PLAIN));
        return jTextArea;
    }

    private static final Unit clearEditorUI$lambda$1$lambda$0(Disposable $it) {
        $it.dispose();
        return Unit.INSTANCE;
    }

    private static final void revertDiff$lambda$2(VerticalDiffBlock this$0) {
        int startOffset = this$0.editor.getDocument().getLineStartOffset(this$0.startLine);
        int endOffset = this$0.editor.getDocument().getLineEndOffset(this$0.startLine + this$0.addedLines.size() - 1) + 1;
        this$0.editor.getDocument().deleteString(startOffset, endOffset);
        if (!((Collection)this$0.deletedLines).isEmpty()) {
            Document document = this$0.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            UpdateFileSilentUtilsKt.insertString(document, startOffset, CollectionsKt.joinToString$default((Iterable)this$0.deletedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n");
        }
    }
}

