/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\b\u0010\r\u001a\u0004\u0018\u00010\bJ\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/PromptHistory;", "", "capacity", "", "<init>", "(I)V", "history", "", "", "currentIndex", "add", "", "item", "getPrevious", "getNext", "isNotEmpty", "", "resetHistory", "coderider-kilo-jetbrains"})
public class PromptHistory {
    private final int capacity;
    @NotNull
    private final List<String> history;
    private int currentIndex;

    public PromptHistory(int capacity) {
        this.capacity = capacity;
        this.history = new ArrayList();
    }

    public final void add(@NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.history.add(item);
        if (this.history.size() > this.capacity) {
            this.history.remove(0);
        }
        this.resetHistory();
    }

    @Nullable
    public final String getPrevious() {
        if (this.currentIndex > 0) {
            int n = this.currentIndex;
            this.currentIndex = n + -1;
        }
        return (String)CollectionsKt.getOrNull(this.history, (int)this.currentIndex);
    }

    @Nullable
    public final String getNext() {
        if (this.currentIndex < this.history.size()) {
            int n = this.currentIndex;
            this.currentIndex = n + 1;
        }
        return (String)CollectionsKt.getOrNull(this.history, (int)this.currentIndex);
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.history).isEmpty();
    }

    public final void resetHistory() {
        this.currentIndex = this.history.size();
    }
}

