/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.config;

import cn.gitlab.kilo.jetbrains.common.Task;
import com.google.gson.Gson;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="coderider-kilo.TaskStorage", storages={@Storage(value="coderider-kilo/tasks/index.xml")})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/gitlab/kilo/jetbrains/config/TaskStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcn/gitlab/kilo/jetbrains/config/TaskStorage$TaskIndex;", "<init>", "()V", "taskDir", "", "index", "gson", "Lcom/google/gson/Gson;", "getState", "loadState", "", "state", "getTaskFile", "Ljava/io/File;", "id", "getTasks", "", "Lcn/gitlab/kilo/jetbrains/common/Task;", "getTask", "tasksEmpty", "", "putTask", "task", "containsTask", "removeTask", "removeAll", "TaskIndex", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTaskStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskStorage.kt\ncn/gitlab/kilo/jetbrains/config/TaskStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class TaskStorage
implements PersistentStateComponent<TaskIndex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String taskDir = PathManager.getConfigPath() + "/tasks";
    @NotNull
    private TaskIndex index = new TaskIndex();
    @NotNull
    private final Gson gson = new Gson();

    @NotNull
    public TaskIndex getState() {
        return this.index;
    }

    public void loadState(@NotNull TaskIndex state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.index = state;
    }

    private final File getTaskFile(String id) {
        File dir = new File(this.taskDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, id + ".json");
    }

    @NotNull
    public final Map<String, Task> getTasks() {
        Map result2 = new LinkedHashMap();
        for (String id : this.index.getTaskIds()) {
            Task it;
            if (this.getTask(id) == null) continue;
            boolean bl = false;
            result2.put(id, it);
        }
        return result2;
    }

    @Nullable
    public final Task getTask(@NotNull String id) {
        Task task;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        File file = this.getTaskFile(id);
        if (!file.exists()) {
            return null;
        }
        try {
            task = (Task)this.gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), Task.class);
        }
        catch (Exception e) {
            task = null;
        }
        return task;
    }

    public final boolean tasksEmpty() {
        return this.index.getTaskIds().isEmpty();
    }

    public final void putTask(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String id = task.getTaskId();
        File file = this.getTaskFile(id);
        file.getParentFile().mkdirs();
        String string = this.gson.toJson((Object)task);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        this.index.getTaskIds().add(id);
    }

    public final boolean containsTask(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.index.getTaskIds().contains(id);
    }

    public final void removeTask(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        File file = this.getTaskFile(id);
        if (file.exists()) {
            file.delete();
        }
        this.index.getTaskIds().remove(id);
    }

    public final void removeAll() {
        for (String id : this.index.getTaskIds()) {
            File file = this.getTaskFile(id);
            if (!file.exists()) continue;
            file.delete();
        }
        this.index.getTaskIds().clear();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/gitlab/kilo/jetbrains/config/TaskStorage$Companion;", "", "<init>", "()V", "instance", "Lcn/gitlab/kilo/jetbrains/config/TaskStorage;", "getInstance", "()Lcn/gitlab/kilo/jetbrains/config/TaskStorage;", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nTaskStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskStorage.kt\ncn/gitlab/kilo/jetbrains/config/TaskStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,110:1\n40#2,3:111\n*S KotlinDebug\n*F\n+ 1 TaskStorage.kt\ncn/gitlab/kilo/jetbrains/config/TaskStorage$Companion\n*L\n107#1:111,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TaskStorage getInstance() {
            boolean $i$f$service = false;
            Class<TaskStorage> serviceClass$iv = TaskStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TaskStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcn/gitlab/kilo/jetbrains/config/TaskStorage$TaskIndex;", "", "<init>", "()V", "taskIds", "", "", "getTaskIds", "()Ljava/util/Set;", "setTaskIds", "(Ljava/util/Set;)V", "coderider-kilo-jetbrains"})
    public static final class TaskIndex {
        @NotNull
        private volatile Set<String> taskIds = new LinkedHashSet();

        @NotNull
        public final Set<String> getTaskIds() {
            return this.taskIds;
        }

        public final void setTaskIds(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.taskIds = set;
        }
    }
}

