/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.config;

import cn.gitlab.kilo.jetbrains.common.ChatMessage;
import cn.gitlab.kilo.jetbrains.common.Conversation;
import com.google.gson.Gson;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="coderider-kilo.ConversationStorage", storages={@Storage(value="coderider-kilo/conversations/index.xml")})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/gitlab/kilo/jetbrains/config/ConversationStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcn/gitlab/kilo/jetbrains/config/ConversationStorage$ConversationIndex;", "<init>", "()V", "conversationDir", "", "index", "gson", "Lcom/google/gson/Gson;", "getState", "loadState", "", "state", "getConversationFile", "Ljava/io/File;", "id", "getConversations", "", "Lcn/gitlab/kilo/jetbrains/common/Conversation;", "getConversation", "isEmptyConversation", "", "conversation", "putConversation", "containsConversation", "removeConversation", "removeAll", "ConversationIndex", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nConversationStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationStorage.kt\ncn/gitlab/kilo/jetbrains/config/ConversationStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n1740#3,3:128\n*S KotlinDebug\n*F\n+ 1 ConversationStorage.kt\ncn/gitlab/kilo/jetbrains/config/ConversationStorage\n*L\n71#1:128,3\n*E\n"})
public final class ConversationStorage
implements PersistentStateComponent<ConversationIndex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String conversationDir = PathManager.getConfigPath() + "/conversations";
    @NotNull
    private ConversationIndex index = new ConversationIndex();
    @NotNull
    private final Gson gson = new Gson();

    @NotNull
    public ConversationIndex getState() {
        return this.index;
    }

    public void loadState(@NotNull ConversationIndex state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.index = state;
    }

    private final File getConversationFile(String id) {
        File dir = new File(this.conversationDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, id + ".json");
    }

    @NotNull
    public final Map<String, Conversation> getConversations() {
        Map result2 = new LinkedHashMap();
        for (String id : this.index.getConversationIds()) {
            Conversation it;
            if (this.getConversation(id) == null) continue;
            boolean bl = false;
            result2.put(id, it);
        }
        return result2;
    }

    @Nullable
    public final Conversation getConversation(@NotNull String id) {
        Conversation conversation;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        File file = this.getConversationFile(id);
        if (!file.exists()) {
            return null;
        }
        try {
            conversation = (Conversation)this.gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), Conversation.class);
        }
        catch (Exception e) {
            conversation = null;
        }
        return conversation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEmptyConversation(Conversation conversation) {
        boolean bl;
        if (conversation.getMessages().isEmpty()) return true;
        Iterable $this$all$iv = conversation.getMessages().values();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            ChatMessage message = (ChatMessage)element$iv;
            boolean bl2 = false;
            CharSequence charSequence = message.getText();
            if (charSequence != null) {
                if (!StringsKt.isBlank((CharSequence)charSequence)) return false;
            }
            boolean bl3 = true;
            if (!bl3) return false;
            charSequence = message.getDisplayText();
            if (charSequence != null) {
                if (!StringsKt.isBlank((CharSequence)charSequence)) return false;
            }
            boolean bl4 = true;
            if (!bl4) return false;
            charSequence = message.getCommandType();
            if (charSequence != null) {
                if (!StringsKt.isBlank((CharSequence)charSequence)) return false;
            }
            boolean bl5 = true;
            if (!bl5) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public final synchronized void putConversation(@NotNull Conversation conversation) {
        Intrinsics.checkNotNullParameter((Object)conversation, (String)"conversation");
        if (this.isEmptyConversation(conversation)) {
            return;
        }
        String id = conversation.getConversationId();
        File file = this.getConversationFile(id);
        file.getParentFile().mkdirs();
        String string = this.gson.toJson((Object)conversation);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        this.index.getConversationIds().add(id);
    }

    public final boolean containsConversation(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.index.getConversationIds().contains(id);
    }

    public final synchronized void removeConversation(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        File file = this.getConversationFile(id);
        if (file.exists()) {
            file.delete();
        }
        this.index.getConversationIds().remove(id);
    }

    public final synchronized void removeAll() {
        for (String id : CollectionsKt.toList((Iterable)this.index.getConversationIds())) {
            File file = this.getConversationFile(id);
            if (!file.exists()) continue;
            file.delete();
        }
        this.index.getConversationIds().clear();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/gitlab/kilo/jetbrains/config/ConversationStorage$Companion;", "", "<init>", "()V", "instance", "Lcn/gitlab/kilo/jetbrains/config/ConversationStorage;", "getInstance", "()Lcn/gitlab/kilo/jetbrains/config/ConversationStorage;", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nConversationStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationStorage.kt\ncn/gitlab/kilo/jetbrains/config/ConversationStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,126:1\n40#2,3:127\n*S KotlinDebug\n*F\n+ 1 ConversationStorage.kt\ncn/gitlab/kilo/jetbrains/config/ConversationStorage$Companion\n*L\n124#1:127,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConversationStorage getInstance() {
            boolean $i$f$service = false;
            Class<ConversationStorage> serviceClass$iv = ConversationStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ConversationStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcn/gitlab/kilo/jetbrains/config/ConversationStorage$ConversationIndex;", "", "<init>", "()V", "conversationIds", "", "", "getConversationIds", "()Ljava/util/Set;", "setConversationIds", "(Ljava/util/Set;)V", "coderider-kilo-jetbrains"})
    public static final class ConversationIndex {
        @NotNull
        private volatile Set<String> conversationIds = new LinkedHashSet();

        @NotNull
        public final Set<String> getConversationIds() {
            return this.conversationIds;
        }

        public final void setConversationIds(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.conversationIds = set;
        }
    }
}

