/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.config;

import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.Rag;
import cn.gitlab.kilo.jetbrains.common.RagSelectItem;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.ui.JBColor;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="coderider-kilo..Configuration", storages={@Storage(value="coderider-kilo/plugin-configure.xml")})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u0016\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\f2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u000fJ\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u000fJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\b\u0010\u001d\u001a\u00020\u001bH\u0002R\u001a\u0010\u0005\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration$PluginState;", "<init>", "()V", "config", "getConfig", "()Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration$PluginState;", "setConfig", "(Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration$PluginState;)V", "getState", "loadState", "", "state", "getRags", "", "Lcn/gitlab/kilo/jetbrains/common/Rag;", "setRags", "rags", "getRagByKbId", "kbId", "", "setSelectedRags", "selectedRags", "Lcn/gitlab/kilo/jetbrains/common/RagSelectItem;", "getSelectedRags", "needLogin", "", "isLogin", "isTokenRefreshable", "PluginState", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nCockpitConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CockpitConfiguration.kt\ncn/gitlab/kilo/jetbrains/config/CockpitConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1#2:149\n295#3,2:150\n*S KotlinDebug\n*F\n+ 1 CockpitConfiguration.kt\ncn/gitlab/kilo/jetbrains/config/CockpitConfiguration\n*L\n97#1:150,2\n*E\n"})
public final class CockpitConfiguration
implements PersistentStateComponent<PluginState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PluginState config = new PluginState();

    @NotNull
    public final PluginState getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull PluginState pluginState) {
        Intrinsics.checkNotNullParameter((Object)pluginState, (String)"<set-?>");
        this.config = pluginState;
    }

    @NotNull
    public PluginState getState() {
        return this.config;
    }

    public void loadState(@NotNull PluginState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.config = state;
    }

    @Nullable
    public final List<Rag> getRags() {
        List list;
        String string = this.getState().getRagsJson();
        if (string != null) {
            String it = string;
            boolean bl = false;
            list = (List)new Gson().fromJson(this.getState().getRagsJson(), new TypeToken<List<? extends Rag>>(){}.getType());
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRags(@Nullable List<Rag> rags2) {
        String string;
        PluginState pluginState = this.getState();
        List<Rag> list = rags2;
        if (list != null) {
            void it;
            List<Rag> list2 = list;
            PluginState pluginState2 = pluginState;
            boolean bl = false;
            string = new Gson().toJson((Object)it);
            pluginState = pluginState2;
        } else {
            string = null;
        }
        pluginState.setRagsJson(string);
    }

    @Nullable
    public final Rag getRagByKbId(@NotNull String kbId) {
        Rag rag;
        Intrinsics.checkNotNullParameter((Object)kbId, (String)"kbId");
        List<Rag> list = this.getRags();
        if (list != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Rag it = (Rag)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getProjectId(), (Object)kbId)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            rag = v1;
        } else {
            rag = null;
        }
        return rag;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSelectedRags(@Nullable List<RagSelectItem> selectedRags) {
        String string;
        PluginState pluginState = this.getState();
        List<RagSelectItem> list = selectedRags;
        if (list != null) {
            void p0;
            List<RagSelectItem> list2 = list;
            Gson gson = new Gson();
            List<RagSelectItem> list3 = list2;
            PluginState pluginState2 = pluginState;
            boolean bl = false;
            string = gson.toJson((Object)p0);
            pluginState = pluginState2;
        } else {
            string = null;
        }
        pluginState.setSelectedRagsJson(string);
    }

    @Nullable
    public final List<RagSelectItem> getSelectedRags() {
        CharSequence charSequence = this.getState().getSelectedRagsJson();
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        List rags2 = (List)new Gson().fromJson(this.getState().getSelectedRagsJson(), new TypeToken<List<? extends RagSelectItem>>(){}.getType());
        List<Rag> list = this.getRags();
        if (list == null || (list = list.stream()) == null || (list = list.map(arg_0 -> CockpitConfiguration.getSelectedRags$lambda$4(CockpitConfiguration::getSelectedRags$lambda$3, arg_0))) == null || (list = list.collect(Collectors.toSet())) == null) {
            list = SetsKt.emptySet();
        }
        Stream<String> ragsIds = list;
        return rags2.stream().filter(arg_0 -> CockpitConfiguration.getSelectedRags$lambda$6(arg_0 -> CockpitConfiguration.getSelectedRags$lambda$5(ragsIds, arg_0), arg_0)).collect(Collectors.toList());
    }

    public final boolean needLogin() {
        boolean bl;
        if (this.getState().getGitlabPAT() == null || this.getState().getCoderiderAuthToken() == null || this.getState().getUserName() == null) {
            return true;
        }
        String string = this.getState().getCoderiderAuthTokenExpiredAt();
        Intrinsics.checkNotNull((Object)string);
        Instant expiredAtUtc = LocalDateTime.parse(string, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS")).atZone(ZoneOffset.UTC).toInstant();
        Instant nowUtc = LocalDateTime.now(ZoneOffset.UTC).atZone(ZoneOffset.UTC).toInstant();
        if (expiredAtUtc.isBefore(nowUtc) && !this.isTokenRefreshable()) {
            CoderiderClientKt.logout();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isLogin() {
        return this.getState().getCoderiderAuthToken() != null;
    }

    private final boolean isTokenRefreshable() {
        boolean bl;
        try {
            CoderiderClient.refreshMetaData$default(new CoderiderClient(this.getState().getCoderiderServerHost()), null, 0, 0L, 7, null);
            bl = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private static final String getSelectedRags$lambda$3(Rag it) {
        return it.getProjectId();
    }

    private static final String getSelectedRags$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean getSelectedRags$lambda$5(Set $ragsIds, RagSelectItem it) {
        return $ragsIds.contains(it.getKbProjectId());
    }

    private static final boolean getSelectedRags$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration$Companion;", "", "<init>", "()V", "instance", "Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration;", "getInstance", "()Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration;", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nCockpitConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CockpitConfiguration.kt\ncn/gitlab/kilo/jetbrains/config/CockpitConfiguration$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,148:1\n40#2,3:149\n*S KotlinDebug\n*F\n+ 1 CockpitConfiguration.kt\ncn/gitlab/kilo/jetbrains/config/CockpitConfiguration$Companion\n*L\n146#1:149,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CockpitConfiguration getInstance() {
            boolean $i$f$service = false;
            Class<CockpitConfiguration> serviceClass$iv = CockpitConfiguration.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CockpitConfiguration)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\bk\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\tR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001a\u0010(\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\tR\u001c\u0010+\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$R\u001c\u0010.\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\"\"\u0004\b0\u0010$R\u001c\u00101\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\"\"\u0004\b3\u0010$R\u001c\u00104\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\"\"\u0004\b6\u0010$R\u001c\u00107\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\"\"\u0004\b9\u0010$R\u001a\u0010:\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\"\"\u0004\b<\u0010$R\u001c\u0010=\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\"\"\u0004\b?\u0010$R\u001c\u0010@\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\"\"\u0004\bB\u0010$R\u001a\u0010C\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0013\"\u0004\bE\u0010\u0015R\u001a\u0010F\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\"\"\u0004\bH\u0010$R\u001a\u0010I\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u0013\"\u0004\bK\u0010\u0015R\u001a\u0010L\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\"\"\u0004\bN\u0010$R\u001a\u0010O\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0007\"\u0004\bQ\u0010\tR\u001a\u0010R\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u0007\"\u0004\bT\u0010\tR\u001a\u0010U\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u0007\"\u0004\bW\u0010\tR\u001a\u0010X\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u0007\"\u0004\bZ\u0010\tR\u001a\u0010[\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u0007\"\u0004\b]\u0010\tR\u001a\u0010^\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010\u0007\"\u0004\b`\u0010\tR\u001c\u0010a\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\"\"\u0004\bc\u0010$R\u001c\u0010d\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\"\"\u0004\bf\u0010$R\u001c\u0010g\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010\"\"\u0004\bi\u0010$R\u001c\u0010j\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010\"\"\u0004\bl\u0010$R\u001a\u0010m\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010\u0007\"\u0004\bo\u0010\tR\u001c\u0010p\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010\"\"\u0004\br\u0010$R\u001a\u0010s\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010\u0007\"\u0004\bu\u0010\tR\u001a\u0010v\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010\u0007\"\u0004\bx\u0010\tR\u001a\u0010y\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010\u0007\"\u0004\b{\u0010\tR\u001a\u0010|\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b}\u0010\u0007\"\u0004\b~\u0010\tR\u001e\u0010\u007f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0080\u0001\u0010\"\"\u0005\b\u0081\u0001\u0010$R\u001d\u0010\u0082\u0001\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u0007\"\u0005\b\u0084\u0001\u0010\tR\u001d\u0010\u0085\u0001\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0086\u0001\u0010\u0007\"\u0005\b\u0087\u0001\u0010\tR\u001d\u0010\u0088\u0001\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0089\u0001\u0010\u0013\"\u0005\b\u008a\u0001\u0010\u0015\u00a8\u0006\u008b\u0001"}, d2={"Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration$PluginState;", "", "<init>", "()V", "codeCompletionEnabled", "", "getCodeCompletionEnabled", "()Z", "setCodeCompletionEnabled", "(Z)V", "codeCompletionDebounceInterval", "", "getCodeCompletionDebounceInterval", "()J", "setCodeCompletionDebounceInterval", "(J)V", "codeCompletionColor", "", "getCodeCompletionColor", "()I", "setCodeCompletionColor", "(I)V", "commentCompletionEnabled", "getCommentCompletionEnabled", "setCommentCompletionEnabled", "localRetrieverEnabled", "getLocalRetrieverEnabled", "setLocalRetrieverEnabled", "graphRetrieversEnabled", "getGraphRetrieversEnabled", "setGraphRetrieversEnabled", "gitlabHost", "", "getGitlabHost", "()Ljava/lang/String;", "setGitlabHost", "(Ljava/lang/String;)V", "gitlabAccessToken", "getGitlabAccessToken", "setGitlabAccessToken", "savePAT", "getSavePAT", "setSavePAT", "gitlabPAT", "getGitlabPAT", "setGitlabPAT", "userName", "getUserName", "setUserName", "userId", "getUserId", "setUserId", "gitlabDistinctId", "getGitlabDistinctId", "setGitlabDistinctId", "gitlabProjectPath", "getGitlabProjectPath", "setGitlabProjectPath", "coderiderServerHost", "getCoderiderServerHost", "setCoderiderServerHost", "coderiderAuthToken", "getCoderiderAuthToken", "setCoderiderAuthToken", "coderiderAuthTokenExpiredAt", "getCoderiderAuthTokenExpiredAt", "setCoderiderAuthTokenExpiredAt", "defaultChatLanguageIndex", "getDefaultChatLanguageIndex", "setDefaultChatLanguageIndex", "defaultChatLanguage", "getDefaultChatLanguage", "setDefaultChatLanguage", "defaultCommitLanguageIndex", "getDefaultCommitLanguageIndex", "setDefaultCommitLanguageIndex", "defaultCommitLanguage", "getDefaultCommitLanguage", "setDefaultCommitLanguage", "memoryOpen", "getMemoryOpen", "setMemoryOpen", "autoMemoryOpen", "getAutoMemoryOpen", "setAutoMemoryOpen", "debugMode", "getDebugMode", "setDebugMode", "debugVerboseMode", "getDebugVerboseMode", "setDebugVerboseMode", "shouldDoMultiline", "getShouldDoMultiline", "setShouldDoMultiline", "chatEnabled", "getChatEnabled", "setChatEnabled", "ragServerEndpoint", "getRagServerEndpoint", "setRagServerEndpoint", "securityStatement", "getSecurityStatement", "setSecurityStatement", "ragsJson", "getRagsJson", "setRagsJson", "selectedRagsJson", "getSelectedRagsJson", "setSelectedRagsJson", "dashboardOpen", "getDashboardOpen", "setDashboardOpen", "registryHost", "getRegistryHost", "setRegistryHost", "showHint", "getShowHint", "setShowHint", "trustAllSsl", "getTrustAllSsl", "setTrustAllSsl", "inlineButtonEnable", "getInlineButtonEnable", "setInlineButtonEnable", "userUpdated", "getUserUpdated", "setUserUpdated", "gitlabPatUrl", "getGitlabPatUrl", "setGitlabPatUrl", "inlineLocalRetrieverEnabled", "getInlineLocalRetrieverEnabled", "setInlineLocalRetrieverEnabled", "inlineGraphRetrieversEnabled", "getInlineGraphRetrieversEnabled", "setInlineGraphRetrieversEnabled", "inlineEditReferenceLimit", "getInlineEditReferenceLimit", "setInlineEditReferenceLimit", "coderider-kilo-jetbrains"})
    public static final class PluginState {
        private boolean codeCompletionEnabled = true;
        private long codeCompletionDebounceInterval = 400L;
        private int codeCompletionColor = JBColor.GRAY.getRGB();
        private boolean commentCompletionEnabled = true;
        private boolean localRetrieverEnabled = true;
        private boolean graphRetrieversEnabled = true;
        @NotNull
        private String gitlabHost = "https://jihulab.com";
        @Nullable
        private String gitlabAccessToken;
        private boolean savePAT;
        @Nullable
        private String gitlabPAT;
        @Nullable
        private String userName;
        @Nullable
        private String userId;
        @Nullable
        private String gitlabDistinctId = "";
        @Nullable
        private String gitlabProjectPath = "gitlab-cn/coderider/assets";
        @NotNull
        private String coderiderServerHost = "https://coderider.jihulab.com";
        @Nullable
        private String coderiderAuthToken;
        @Nullable
        private String coderiderAuthTokenExpiredAt;
        private int defaultChatLanguageIndex = I18nKt.getLocaleIndex();
        @NotNull
        private String defaultChatLanguage = I18nKt.getLocaleStr();
        private int defaultCommitLanguageIndex = I18nKt.getLocaleIndex();
        @NotNull
        private String defaultCommitLanguage = I18nKt.getLocaleStr();
        private boolean memoryOpen;
        private boolean autoMemoryOpen;
        private boolean debugMode = true;
        private boolean debugVerboseMode;
        private boolean shouldDoMultiline;
        private boolean chatEnabled = true;
        @Nullable
        private String ragServerEndpoint = "https://coderider-rag.jihulab.com";
        @Nullable
        private String securityStatement;
        @Nullable
        private String ragsJson;
        @Nullable
        private String selectedRagsJson;
        private boolean dashboardOpen;
        @Nullable
        private String registryHost = "http://registry.jihulab.com";
        private boolean showHint;
        private boolean trustAllSsl = true;
        private boolean inlineButtonEnable;
        private boolean userUpdated;
        @Nullable
        private String gitlabPatUrl = this.gitlabHost + "/-/user_settings/personal_access_tokens";
        private boolean inlineLocalRetrieverEnabled = true;
        private boolean inlineGraphRetrieversEnabled = true;
        private int inlineEditReferenceLimit = 20;

        public final boolean getCodeCompletionEnabled() {
            return this.codeCompletionEnabled;
        }

        public final void setCodeCompletionEnabled(boolean bl) {
            this.codeCompletionEnabled = bl;
        }

        public final long getCodeCompletionDebounceInterval() {
            return this.codeCompletionDebounceInterval;
        }

        public final void setCodeCompletionDebounceInterval(long l) {
            this.codeCompletionDebounceInterval = l;
        }

        public final int getCodeCompletionColor() {
            return this.codeCompletionColor;
        }

        public final void setCodeCompletionColor(int n) {
            this.codeCompletionColor = n;
        }

        public final boolean getCommentCompletionEnabled() {
            return this.commentCompletionEnabled;
        }

        public final void setCommentCompletionEnabled(boolean bl) {
            this.commentCompletionEnabled = bl;
        }

        public final boolean getLocalRetrieverEnabled() {
            return this.localRetrieverEnabled;
        }

        public final void setLocalRetrieverEnabled(boolean bl) {
            this.localRetrieverEnabled = bl;
        }

        public final boolean getGraphRetrieversEnabled() {
            return this.graphRetrieversEnabled;
        }

        public final void setGraphRetrieversEnabled(boolean bl) {
            this.graphRetrieversEnabled = bl;
        }

        @NotNull
        public final String getGitlabHost() {
            return this.gitlabHost;
        }

        public final void setGitlabHost(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.gitlabHost = string;
        }

        @Nullable
        public final String getGitlabAccessToken() {
            return this.gitlabAccessToken;
        }

        public final void setGitlabAccessToken(@Nullable String string) {
            this.gitlabAccessToken = string;
        }

        public final boolean getSavePAT() {
            return this.savePAT;
        }

        public final void setSavePAT(boolean bl) {
            this.savePAT = bl;
        }

        @Nullable
        public final String getGitlabPAT() {
            return this.gitlabPAT;
        }

        public final void setGitlabPAT(@Nullable String string) {
            this.gitlabPAT = string;
        }

        @Nullable
        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(@Nullable String string) {
            this.userName = string;
        }

        @Nullable
        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(@Nullable String string) {
            this.userId = string;
        }

        @Nullable
        public final String getGitlabDistinctId() {
            return this.gitlabDistinctId;
        }

        public final void setGitlabDistinctId(@Nullable String string) {
            this.gitlabDistinctId = string;
        }

        @Nullable
        public final String getGitlabProjectPath() {
            return this.gitlabProjectPath;
        }

        public final void setGitlabProjectPath(@Nullable String string) {
            this.gitlabProjectPath = string;
        }

        @NotNull
        public final String getCoderiderServerHost() {
            return this.coderiderServerHost;
        }

        public final void setCoderiderServerHost(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.coderiderServerHost = string;
        }

        @Nullable
        public final String getCoderiderAuthToken() {
            return this.coderiderAuthToken;
        }

        public final void setCoderiderAuthToken(@Nullable String string) {
            this.coderiderAuthToken = string;
        }

        @Nullable
        public final String getCoderiderAuthTokenExpiredAt() {
            return this.coderiderAuthTokenExpiredAt;
        }

        public final void setCoderiderAuthTokenExpiredAt(@Nullable String string) {
            this.coderiderAuthTokenExpiredAt = string;
        }

        public final int getDefaultChatLanguageIndex() {
            return this.defaultChatLanguageIndex;
        }

        public final void setDefaultChatLanguageIndex(int n) {
            this.defaultChatLanguageIndex = n;
        }

        @NotNull
        public final String getDefaultChatLanguage() {
            return this.defaultChatLanguage;
        }

        public final void setDefaultChatLanguage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.defaultChatLanguage = string;
        }

        public final int getDefaultCommitLanguageIndex() {
            return this.defaultCommitLanguageIndex;
        }

        public final void setDefaultCommitLanguageIndex(int n) {
            this.defaultCommitLanguageIndex = n;
        }

        @NotNull
        public final String getDefaultCommitLanguage() {
            return this.defaultCommitLanguage;
        }

        public final void setDefaultCommitLanguage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.defaultCommitLanguage = string;
        }

        public final boolean getMemoryOpen() {
            return this.memoryOpen;
        }

        public final void setMemoryOpen(boolean bl) {
            this.memoryOpen = bl;
        }

        public final boolean getAutoMemoryOpen() {
            return this.autoMemoryOpen;
        }

        public final void setAutoMemoryOpen(boolean bl) {
            this.autoMemoryOpen = bl;
        }

        public final boolean getDebugMode() {
            return this.debugMode;
        }

        public final void setDebugMode(boolean bl) {
            this.debugMode = bl;
        }

        public final boolean getDebugVerboseMode() {
            return this.debugVerboseMode;
        }

        public final void setDebugVerboseMode(boolean bl) {
            this.debugVerboseMode = bl;
        }

        public final boolean getShouldDoMultiline() {
            return this.shouldDoMultiline;
        }

        public final void setShouldDoMultiline(boolean bl) {
            this.shouldDoMultiline = bl;
        }

        public final boolean getChatEnabled() {
            return this.chatEnabled;
        }

        public final void setChatEnabled(boolean bl) {
            this.chatEnabled = bl;
        }

        @Nullable
        public final String getRagServerEndpoint() {
            return this.ragServerEndpoint;
        }

        public final void setRagServerEndpoint(@Nullable String string) {
            this.ragServerEndpoint = string;
        }

        @Nullable
        public final String getSecurityStatement() {
            return this.securityStatement;
        }

        public final void setSecurityStatement(@Nullable String string) {
            this.securityStatement = string;
        }

        @Nullable
        public final String getRagsJson() {
            return this.ragsJson;
        }

        public final void setRagsJson(@Nullable String string) {
            this.ragsJson = string;
        }

        @Nullable
        public final String getSelectedRagsJson() {
            return this.selectedRagsJson;
        }

        public final void setSelectedRagsJson(@Nullable String string) {
            this.selectedRagsJson = string;
        }

        public final boolean getDashboardOpen() {
            return this.dashboardOpen;
        }

        public final void setDashboardOpen(boolean bl) {
            this.dashboardOpen = bl;
        }

        @Nullable
        public final String getRegistryHost() {
            return this.registryHost;
        }

        public final void setRegistryHost(@Nullable String string) {
            this.registryHost = string;
        }

        public final boolean getShowHint() {
            return this.showHint;
        }

        public final void setShowHint(boolean bl) {
            this.showHint = bl;
        }

        public final boolean getTrustAllSsl() {
            return this.trustAllSsl;
        }

        public final void setTrustAllSsl(boolean bl) {
            this.trustAllSsl = bl;
        }

        public final boolean getInlineButtonEnable() {
            return this.inlineButtonEnable;
        }

        public final void setInlineButtonEnable(boolean bl) {
            this.inlineButtonEnable = bl;
        }

        public final boolean getUserUpdated() {
            return this.userUpdated;
        }

        public final void setUserUpdated(boolean bl) {
            this.userUpdated = bl;
        }

        @Nullable
        public final String getGitlabPatUrl() {
            return this.gitlabPatUrl;
        }

        public final void setGitlabPatUrl(@Nullable String string) {
            this.gitlabPatUrl = string;
        }

        public final boolean getInlineLocalRetrieverEnabled() {
            return this.inlineLocalRetrieverEnabled;
        }

        public final void setInlineLocalRetrieverEnabled(boolean bl) {
            this.inlineLocalRetrieverEnabled = bl;
        }

        public final boolean getInlineGraphRetrieversEnabled() {
            return this.inlineGraphRetrieversEnabled;
        }

        public final void setInlineGraphRetrieversEnabled(boolean bl) {
            this.inlineGraphRetrieversEnabled = bl;
        }

        public final int getInlineEditReferenceLimit() {
            return this.inlineEditReferenceLimit;
        }

        public final void setInlineEditReferenceLimit(int n) {
            this.inlineEditReferenceLimit = n;
        }
    }
}

