/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.workspace;

import cn.gitlab.kilo.jetbrains.composer.ComposerProvider;
import cn.gitlab.kilo.jetbrains.composer.workspace.WorkspaceTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.ui.jcef.JBCefBrowser;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u000e\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/workspace/WorkspaceTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcn/gitlab/kilo/jetbrains/composer/ComposerProvider;", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcn/gitlab/kilo/jetbrains/composer/ComposerProvider;Lcom/intellij/ui/jcef/JBCefBrowser;)V", "filePaths", "", "", "listener", "cn/gitlab/kilo/jetbrains/composer/workspace/WorkspaceTracker$listener$1", "Lcn/gitlab/kilo/jetbrains/composer/workspace/WorkspaceTracker$listener$1;", "cwd", "populateFilePaths", "", "addFilePath", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "removeFilePath", "", "normalizeFilePath", "path", "isDirectory", "workspaceDidUpdate", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nWorkspaceTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceTracker.kt\ncn/gitlab/kilo/jetbrains/composer/workspace/WorkspaceTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n1563#3:106\n1634#3,3:107\n*S KotlinDebug\n*F\n+ 1 WorkspaceTracker.kt\ncn/gitlab/kilo/jetbrains/composer/workspace/WorkspaceTracker\n*L\n84#1:106\n84#1:107,3\n*E\n"})
public final class WorkspaceTracker
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ComposerProvider provider;
    @NotNull
    private final JBCefBrowser browser;
    @NotNull
    private final Set<String> filePaths;
    @NotNull
    private final listener.1 listener;
    @Nullable
    private final String cwd;

    public WorkspaceTracker(@NotNull Project project, @NotNull ComposerProvider provider, @NotNull JBCefBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        this.project = project;
        this.provider = provider;
        this.browser = browser;
        this.filePaths = new CopyOnWriteArraySet();
        this.listener = new VirtualFileListener(this){
            final /* synthetic */ WorkspaceTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileCreated(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                WorkspaceTracker.access$addFilePath(this.this$0, virtualFile);
                WorkspaceTracker.access$workspaceDidUpdate(this.this$0);
            }

            public void fileDeleted(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (WorkspaceTracker.access$removeFilePath(this.this$0, event.getFile())) {
                    WorkspaceTracker.access$workspaceDidUpdate(this.this$0);
                }
            }

            public void fileMoved(VirtualFileMoveEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                WorkspaceTracker.access$removeFilePath(this.this$0, event.getOldParent().findChild(event.getFileName()));
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                WorkspaceTracker.access$addFilePath(this.this$0, virtualFile);
                WorkspaceTracker.access$workspaceDidUpdate(this.this$0);
            }

            public final void fileRenamed(VirtualFilePropertyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
                    WorkspaceTracker.access$removeFilePath(this.this$0, event.getFile());
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                    WorkspaceTracker.access$addFilePath(this.this$0, virtualFile);
                    WorkspaceTracker.access$workspaceDidUpdate(this.this$0);
                }
            }
        };
        this.cwd = this.project.getBasePath();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.listener, (Disposable)this);
        Unit bus = Unit.INSTANCE;
        this.populateFilePaths();
    }

    private final void populateFilePaths() {
        String string = this.cwd;
        if (string == null) {
            return;
        }
        String rootPath = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(rootPath);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, null, arg_0 -> WorkspaceTracker.populateFilePaths$lambda$0(this, arg_0));
        this.workspaceDidUpdate();
    }

    private final void addFilePath(VirtualFile file) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = this.normalizeFilePath(string, file.isDirectory());
        this.filePaths.add(path);
    }

    private final boolean removeFilePath(VirtualFile file) {
        if (file == null) {
            return false;
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String normalized = this.normalizeFilePath(string, file.isDirectory());
        return this.filePaths.remove(normalized) || this.filePaths.remove(normalized + "/");
    }

    private final String normalizeFilePath(String path, boolean isDirectory) {
        String string;
        block3: {
            block2: {
                string = this.cwd;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = ((Object)Paths.get(it, new String[0]).resolve(Paths.get(path, new String[0])).normalize()).toString();
                string = string2;
                if (string2 != null) break block3;
            }
            string = path;
        }
        String absPath = string;
        return isDirectory && !StringsKt.endsWith$default((String)absPath, (String)"/", (boolean)false, (int)2, null) ? absPath + "/" : absPath;
    }

    /*
     * WARNING - void declaration
     */
    private final void workspaceDidUpdate() {
        void $this$mapTo$iv$iv;
        String string = this.cwd;
        if (string == null) {
            return;
        }
        String cwd = string;
        Iterable $this$map$iv = this.filePaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fullPath;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String rel = StringsKt.replace$default((String)((Object)Paths.get(cwd, new String[0]).relativize(Paths.get((String)fullPath, new String[0]))).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            collection.add(StringsKt.endsWith$default((String)fullPath, (String)"/", (boolean)false, (int)2, null) ? rel + "/" : rel);
        }
        List relativePaths = (List)destination$iv$iv;
        ApplicationManager.getApplication().invokeLater(() -> WorkspaceTracker.workspaceDidUpdate$lambda$4(this, relativePaths));
    }

    public void dispose() {
    }

    private static final boolean populateFilePaths$lambda$0(WorkspaceTracker this$0, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this$0.addFilePath(file);
        return true;
    }

    private static final void workspaceDidUpdate$lambda$4(WorkspaceTracker this$0, List $relativePaths) {
        block0: {
            String string = this$0.provider.getTaskId();
            if (string == null) break block0;
            String taskId = string;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"workspaceUpdated"), TuplesKt.to((Object)"filePaths", (Object)$relativePaths)};
            this$0.provider.postMessageToWebview(MapsKt.mapOf((Pair[])pairArray), taskId);
        }
    }

    public static final /* synthetic */ void access$addFilePath(WorkspaceTracker $this, VirtualFile file) {
        $this.addFilePath(file);
    }

    public static final /* synthetic */ void access$workspaceDidUpdate(WorkspaceTracker $this) {
        $this.workspaceDidUpdate();
    }

    public static final /* synthetic */ boolean access$removeFilePath(WorkspaceTracker $this, VirtualFile file) {
        return $this.removeFilePath(file);
    }
}

