/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.util;

import cn.gitlab.kilo.jetbrains.composer.dto.HistoryItem;
import cn.gitlab.kilo.jetbrains.composer.dto.TaskHistoryRequestPayload;
import cn.gitlab.kilo.jetbrains.composer.dto.TaskHistoryResponsePayload;
import cn.gitlab.kilo.jetbrains.composer.util.FuzzySearchUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/TaskHistoryProcessor;", "", "<init>", "()V", "PAGE_SIZE", "", "processRequest", "Lcn/gitlab/kilo/jetbrains/composer/dto/TaskHistoryResponsePayload;", "taskHistory", "", "Lcn/gitlab/kilo/jetbrains/composer/dto/HistoryItem;", "currentWorkspace", "", "request", "Lcn/gitlab/kilo/jetbrains/composer/dto/TaskHistoryRequestPayload;", "sortTasks", "tasks", "sortType", "searchQuery", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTaskHistoryProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskHistoryProcessor.kt\ncn/gitlab/kilo/jetbrains/composer/util/TaskHistoryProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n774#2:112\n865#2,2:113\n774#2:115\n865#2,2:116\n1563#2:118\n1634#2,3:119\n1056#2:122\n1068#2:123\n1068#2:124\n1068#2:125\n1068#2:126\n1068#2:127\n*S KotlinDebug\n*F\n+ 1 TaskHistoryProcessor.kt\ncn/gitlab/kilo/jetbrains/composer/util/TaskHistoryProcessor\n*L\n24#1:112\n24#1:113,2\n34#1:115\n34#1:116,2\n41#1:118\n41#1:119,3\n79#1:122\n82#1:123\n85#1:124\n99#1:125\n103#1:126\n106#1:127\n*E\n"})
public final class TaskHistoryProcessor {
    @NotNull
    public static final TaskHistoryProcessor INSTANCE = new TaskHistoryProcessor();
    private static final int PAGE_SIZE = 10;

    private TaskHistoryProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TaskHistoryResponsePayload processRequest(@NotNull List<HistoryItem> taskHistory, @NotNull String currentWorkspace, @NotNull TaskHistoryRequestPayload request) {
        HistoryItem it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(taskHistory, (String)"taskHistory");
        Intrinsics.checkNotNullParameter((Object)currentWorkspace, (String)"currentWorkspace");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object $this$filter$iv = taskHistory;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (HistoryItem)element$iv$iv;
            boolean bl = false;
            if (!(it.getTs() > 0L && !StringsKt.isBlank((CharSequence)it.getTask()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tasks = (List)destination$iv$iv;
        if (request.getFavoritesOnly()) {
            $this$filter$iv = tasks;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (HistoryItem)element$iv$iv;
                boolean bl = false;
                if (!it.isFavorited()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tasks = (List)destination$iv$iv;
        }
        if (!(($this$filter$iv = (CharSequence)request.getSearch()) == null || StringsKt.isBlank((CharSequence)$this$filter$iv))) {
            void $this$mapTo$iv$iv;
            List searchResults = FuzzySearchUtil.INSTANCE.search(tasks, request.getSearch(), TaskHistoryProcessor::processRequest$lambda$2);
            Iterable $this$map$iv = searchResults;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void matchResult;
                HistoryItem historyItem;
                FuzzySearchUtil.FuzzyMatch bl = (FuzzySearchUtil.FuzzyMatch)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                HistoryItem $this$processRequest_u24lambda_u244_u24lambda_u243 = historyItem = HistoryItem.copy$default((HistoryItem)matchResult.getItem(), null, 0L, null, 0L, 0L, 0, 0, 0.0, 0L, null, null, null, null, 0, null, false, false, null, null, 524287, null);
                boolean bl3 = false;
                $this$processRequest_u24lambda_u244_u24lambda_u243.setHighlight(FuzzySearchUtil.INSTANCE.highlightMatches($this$processRequest_u24lambda_u244_u24lambda_u243.getTask(), matchResult.getPositions()));
                collection.add(historyItem);
            }
            tasks = (List)destination$iv$iv2;
        }
        int pageCount = (tasks = this.sortTasks(tasks, request.getSort(), request.getSearch())).isEmpty() ? 0 : (tasks.size() - 1) / 10 + 1;
        int pageIndex = RangesKt.coerceIn((int)request.getPageIndex(), (int)0, (int)RangesKt.coerceAtLeast((int)(pageCount - 1), (int)0));
        int startIndex = 10 * pageIndex;
        int endIndex = RangesKt.coerceAtMost((int)(startIndex + 10), (int)tasks.size());
        List<HistoryItem> historyItems = startIndex < tasks.size() ? tasks.subList(startIndex, endIndex) : CollectionsKt.emptyList();
        return new TaskHistoryResponsePayload(request.getRequestId(), historyItems, pageIndex, pageCount);
    }

    private final List<HistoryItem> sortTasks(List<HistoryItem> tasks, String sortType, String searchQuery) {
        return switch (sortType) {
            case "oldest" -> {
                Iterable $this$sortedBy$iv = tasks;
                boolean $i$f$sortedBy = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistoryItem it = (HistoryItem)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTs());
                        it = (HistoryItem)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTs()));
                    }
                });
            }
            case "mostExpensive" -> {
                Iterable $this$sortedByDescending$iv = tasks;
                boolean $i$f$sortedByDescending = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistoryItem it = (HistoryItem)b;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getTotalCost());
                        it = (HistoryItem)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getTotalCost()));
                    }
                });
            }
            case "mostTokens" -> {
                Iterable $this$sortedByDescending$iv = tasks;
                boolean $i$f$sortedByDescending = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistoryItem item = (HistoryItem)b;
                        boolean bl = false;
                        long tokensIn = item.getTokensIn();
                        long tokensOut = item.getTokensOut();
                        int cacheWrites = item.getCacheWrites();
                        int cacheReads = item.getCacheReads();
                        item = (HistoryItem)a;
                        Comparable comparable = Long.valueOf(tokensIn + tokensOut + (long)cacheWrites + (long)cacheReads);
                        bl = false;
                        tokensIn = item.getTokensIn();
                        tokensOut = item.getTokensOut();
                        cacheWrites = item.getCacheWrites();
                        cacheReads = item.getCacheReads();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Long.valueOf(tokensIn + tokensOut + (long)cacheWrites + (long)cacheReads));
                    }
                });
            }
            case "mostRelevant" -> {
                Object $this$sortedByDescending$iv = searchQuery;
                if (!($this$sortedByDescending$iv == null || StringsKt.isBlank((CharSequence)$this$sortedByDescending$iv))) {
                    yield tasks;
                }
                $this$sortedByDescending$iv = tasks;
                boolean $i$f$sortedByDescending = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistoryItem it = (HistoryItem)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTs());
                        it = (HistoryItem)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTs()));
                    }
                });
            }
            case "newest" -> {
                Iterable $this$sortedByDescending$iv = tasks;
                boolean $i$f$sortedByDescending = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistoryItem it = (HistoryItem)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTs());
                        it = (HistoryItem)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTs()));
                    }
                });
            }
            default -> {
                Iterable $this$sortedByDescending$iv = tasks;
                boolean $i$f$sortedByDescending = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistoryItem it = (HistoryItem)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTs());
                        it = (HistoryItem)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTs()));
                    }
                });
            }
        };
    }

    private static final String processRequest$lambda$2(HistoryItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTask();
    }
}

