/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.util;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.composer.util.GitCommit;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/GitUtils;", "", "<init>", "()V", "GIT_OUTPUT_LINE_LIMIT", "", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "isValidCommitHash", "", "", "getWorkingState", "cwd", "getCommitInfo", "hash", "searchCommits", "", "Lcn/gitlab/kilo/jetbrains/composer/util/GitCommit;", "query", "checkGitInstalled", "checkGitRepo", "executeCommand", "command", "truncateOutput", "content", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nGitUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUtil.kt\ncn/gitlab/kilo/jetbrains/composer/util/GitUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,148:1\n1#2:149\n1#2:163\n827#3:150\n855#3,2:151\n1617#3,9:153\n1869#3:162\n1870#3:164\n1626#3:165\n37#4:166\n36#4,3:167\n*S KotlinDebug\n*F\n+ 1 GitUtil.kt\ncn/gitlab/kilo/jetbrains/composer/util/GitUtils\n*L\n90#1:163\n88#1:150\n88#1:151,2\n90#1:153,9\n90#1:162\n90#1:164\n90#1:165\n118#1:166\n118#1:167,3\n*E\n"})
public final class GitUtils {
    @NotNull
    public static final GitUtils INSTANCE = new GitUtils();
    private static final int GIT_OUTPUT_LINE_LIMIT = 500;
    @NotNull
    private static final Logger logger = Logger.Companion.getInstance(GitUtils.class);

    private GitUtils() {
    }

    private final boolean isValidCommitHash(String $this$isValidCommitHash) {
        CharSequence charSequence = $this$isValidCommitHash;
        return new Regex("^[a-f0-9]+$", RegexOption.IGNORE_CASE).matches(charSequence);
    }

    @NotNull
    public final String getWorkingState(@NotNull String cwd) {
        Object object;
        Object $this$getWorkingState_u24lambda_u243;
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        Object object2 = this;
        try {
            $this$getWorkingState_u24lambda_u243 = object2;
            boolean bl = false;
            if (!super.checkGitInstalled(cwd)) {
                boolean $i$a$-require-GitUtils$getWorkingState$1$42 = false;
                String $i$a$-require-GitUtils$getWorkingState$1$42 = "Git is not installed";
                throw new IllegalArgumentException($i$a$-require-GitUtils$getWorkingState$1$42.toString());
            }
            if (!super.checkGitRepo(cwd)) {
                boolean $i$a$-require-GitUtils$getWorkingState$1$52 = false;
                String $i$a$-require-GitUtils$getWorkingState$1$52 = "Not a git repository";
                throw new IllegalArgumentException($i$a$-require-GitUtils$getWorkingState$1$52.toString());
            }
            String status = ((Object)StringsKt.trim((CharSequence)super.executeCommand("git status --short", cwd))).toString();
            if (!(((CharSequence)status).length() > 0)) {
                boolean $i$a$-require-GitUtils$getWorkingState$1$62 = false;
                String $i$a$-require-GitUtils$getWorkingState$1$62 = "No changes in working directory";
                throw new IllegalArgumentException($i$a$-require-GitUtils$getWorkingState$1$62.toString());
            }
            String diff = ((Object)StringsKt.trim((CharSequence)super.executeCommand("git diff HEAD", cwd))).toString();
            String output = ((Object)StringsKt.trim((CharSequence)("Working directory changes:\n\n" + status + "\n\n" + diff))).toString();
            $this$getWorkingState_u24lambda_u243 = Result.constructor-impl((Object)super.truncateOutput(output));
        }
        catch (Throwable bl) {
            $this$getWorkingState_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getWorkingState_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            logger.warn("Error getting working state: ", e);
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            object = "Failed to get working state: " + string;
        }
        return (String)object;
    }

    @NotNull
    public final String getCommitInfo(@NotNull String hash, @NotNull String cwd) {
        Object object;
        Object $this$getCommitInfo_u24lambda_u249;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        Object object2 = this;
        try {
            StringBuilder stringBuilder;
            $this$getCommitInfo_u24lambda_u249 = object2;
            boolean bl = false;
            if (!super.checkGitInstalled(cwd)) {
                boolean $i$a$-require-GitUtils$getCommitInfo$1$32 = false;
                String $i$a$-require-GitUtils$getCommitInfo$1$32 = "Git is not installed";
                throw new IllegalArgumentException($i$a$-require-GitUtils$getCommitInfo$1$32.toString());
            }
            if (!super.checkGitRepo(cwd)) {
                boolean $i$a$-require-GitUtils$getCommitInfo$1$42 = false;
                String $i$a$-require-GitUtils$getCommitInfo$1$42 = "Not a git repository";
                throw new IllegalArgumentException($i$a$-require-GitUtils$getCommitInfo$1$42.toString());
            }
            List commitInfo = StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)super.executeCommand("git show --format=%H%n%h%n%s%n%an%n%ad%n%b --no-patch " + hash, cwd))).toString());
            String fullHash = (String)commitInfo.get(0);
            String shortHash = (String)commitInfo.get(1);
            String subject = (String)commitInfo.get(2);
            String author = (String)commitInfo.get(3);
            String date = (String)commitInfo.get(4);
            String string = (String)CollectionsKt.getOrNull((List)commitInfo, (int)5);
            if (string == null) {
                string = "";
            }
            String body = string;
            StringBuilder $this$getCommitInfo_u24lambda_u249_u24lambda_u247 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append("Commit: " + shortHash + " (" + fullHash + ")").append('\n');
            $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append("Author: " + author).append('\n');
            $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append("Date: " + date).append('\n');
            $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append("\nMessage: " + subject).append('\n');
            if (!StringsKt.isBlank((CharSequence)body)) {
                $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append("\nDescription:\n" + body).append('\n');
            }
            $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append("\nFiles Changed:").append('\n');
            $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append(((Object)StringsKt.trim((CharSequence)super.executeCommand("git show --stat " + hash, cwd))).toString()).append('\n');
            $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append("\nFull Changes:\n\n").append('\n');
            $this$getCommitInfo_u24lambda_u249_u24lambda_u247.append(((Object)StringsKt.trim((CharSequence)super.executeCommand("git show " + hash, cwd))).toString()).append('\n');
            String it = stringBuilder.toString();
            boolean bl3 = false;
            $this$getCommitInfo_u24lambda_u249 = Result.constructor-impl((Object)super.truncateOutput(it));
        }
        catch (Throwable bl) {
            $this$getCommitInfo_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getCommitInfo_u24lambda_u249;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            logger.warn("Error getting commit info: ", e);
            object = "Error fetching commit info: " + e.getMessage();
        }
        return (String)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GitCommit> searchCommits(@NotNull String query, @NotNull String cwd) {
        Object $this$searchCommits_u24lambda_u2414;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        Object object = this;
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            String output;
            String string;
            $this$searchCommits_u24lambda_u2414 = object;
            boolean bl = false;
            if (!super.checkGitInstalled(cwd)) {
                Logger.warn$default(logger, "Git is not installed", null, 2, null);
                return CollectionsKt.emptyList();
            }
            if (!super.checkGitRepo(cwd)) {
                Logger.warn$default(logger, "Not a git repository", null, 2, null);
                return CollectionsKt.emptyList();
            }
            String logFormat = "%H%n%h%n%s%n%an%n%ad";
            String it = string = super.executeCommand("git log -n 10 --format=" + logFormat + " --date=short --grep=" + query + " --regexp-ignore-case", cwd);
            boolean bl2 = false;
            String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
            if (string2 == null) {
                string2 = super.isValidCommitHash(query) ? super.executeCommand("git log -n 10 --format=" + logFormat + " --date=short --author-date-order " + query, cwd) : "";
            }
            if (StringsKt.isBlank((CharSequence)(output = string2))) {
                return CollectionsKt.emptyList();
            }
            Iterable iterable = StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)output)).toString());
            boolean $i$f$filterNot = false;
            it = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it2 = (String)element$iv$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it2, (Object)"--")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)5);
            boolean $i$f$mapNotNull = false;
            $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                GitCommit it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                List chunk = (List)element$iv$iv;
                boolean bl5 = false;
                if ((chunk.size() == 5 ? new GitCommit((String)chunk.get(0), (String)chunk.get(1), (String)chunk.get(2), (String)chunk.get(3), (String)chunk.get(4)) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$searchCommits_u24lambda_u2414 = Result.constructor-impl((Object)((List)destination$iv$iv));
        }
        catch (Throwable bl) {
            $this$searchCommits_u24lambda_u2414 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$searchCommits_u24lambda_u2414;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            logger.warn("Error searching commits: ", e);
            return CollectionsKt.emptyList();
        }
        return (List)object;
    }

    private final boolean checkGitInstalled(String cwd) {
        Object object;
        Object $this$checkGitInstalled_u24lambda_u2416;
        Object object2 = this;
        try {
            $this$checkGitInstalled_u24lambda_u2416 = object2;
            boolean bl = false;
            $this$checkGitInstalled_u24lambda_u2416 = Result.constructor-impl((Object)(!StringsKt.isBlank((CharSequence)super.executeCommand("git --version", cwd)) ? 1 : 0));
        }
        catch (Throwable bl) {
            $this$checkGitInstalled_u24lambda_u2416 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$checkGitInstalled_u24lambda_u2416;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            logger.warn("Error checking git installation: ", e);
            object = false;
        }
        return (Boolean)object;
    }

    private final boolean checkGitRepo(String cwd) {
        Object object;
        Object $this$checkGitRepo_u24lambda_u2418;
        Object object2 = this;
        try {
            $this$checkGitRepo_u24lambda_u2418 = object2;
            boolean bl = false;
            $this$checkGitRepo_u24lambda_u2418 = Result.constructor-impl((Object)Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)super.executeCommand("git rev-parse --is-inside-work-tree", cwd))).toString(), (Object)"true"));
        }
        catch (Throwable bl) {
            $this$checkGitRepo_u24lambda_u2418 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$checkGitRepo_u24lambda_u2418;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = false;
        }
        return (Boolean)object;
    }

    private final String executeCommand(String command, String cwd) {
        Object object = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)command, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Process process2 = new ProcessBuilder(new String[0]).command(Arrays.copyOf(stringArray, stringArray.length)).directory(new File(cwd)).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
        InputStream inputStream = process2.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        object = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)object, charset);
        int n = 8192;
        String output = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        process2.waitFor();
        if (process2.exitValue() != 0) {
            InputStream inputStream2 = process2.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
            object = inputStream2;
            charset = Charsets.UTF_8;
            reader = new InputStreamReader((InputStream)object, charset);
            n = 8192;
            throw new Exception(TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))));
        }
        return output;
    }

    private final String truncateOutput(String content2) {
        StringBuilder stringBuilder;
        List lines = StringsKt.lines((CharSequence)content2);
        if (lines.size() <= 500) {
            return content2;
        }
        int beforeLimit = 100;
        int afterLimit = 500 - beforeLimit;
        StringBuilder $this$truncateOutput_u24lambda_u2420 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$truncateOutput_u24lambda_u2420.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)lines, (int)beforeLimit), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        $this$truncateOutput_u24lambda_u2420.append("\n[..." + (lines.size() - 500) + " lines omitted...]\n");
        $this$truncateOutput_u24lambda_u2420.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)lines, (int)afterLimit), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return stringBuilder.toString();
    }
}

