/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.rules;

import cn.gitlab.kilo.jetbrains.common.I18nKt;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J \u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020\tJ\u0018\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tJ\u001a\u0010)\u001a\u0004\u0018\u00010\u001c2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0002J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/rules/RuleService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createRuleFile", "", "filename", "", "isGlobal", "", "ruleType", "sanitizeFilename", "input", "toggleRule", "rulePath", "enabled", "toggleWorkflow", "path", "deleteRuleFile", "buildRulesData", "Lcom/google/gson/JsonObject;", "updateToggle", "key", "getEnabledRulesFromDirectory", "", "dir", "Ljava/nio/file/Path;", "toggleKey", "openFileInEditor", "filePath", "notify", "title", "content", "type", "Lcom/intellij/notification/NotificationType;", "buildRulesAndWorkflowsSection", "buildExplicitInstructionsForWorkflow", "cwd", "commandName", "findEnabledWorkflow", "loadWorkflowToggles", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nRuleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleService.kt\ncn/gitlab/kilo/jetbrains/composer/rules/RuleService\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,392:1\n37#2:393\n36#2,3:394\n1#3:397\n478#4:398\n424#4:399\n463#4:404\n413#4:405\n478#4:410\n424#4:411\n463#4:416\n413#4:417\n478#4:424\n424#4:425\n463#4:430\n413#4:431\n478#4:439\n424#4:440\n463#4:445\n413#4:446\n1252#5,4:400\n1252#5,4:406\n1252#5,4:412\n1252#5,4:418\n295#5,2:422\n1252#5,4:426\n1252#5,4:432\n1761#5,3:436\n1252#5,4:441\n1252#5,4:447\n1761#5,3:451\n*S KotlinDebug\n*F\n+ 1 RuleService.kt\ncn/gitlab/kilo/jetbrains/composer/rules/RuleService\n*L\n49#1:393\n49#1:394,3\n183#1:398\n183#1:399\n184#1:404\n184#1:405\n207#1:410\n207#1:411\n208#1:416\n208#1:417\n386#1:424\n386#1:425\n387#1:430\n387#1:431\n269#1:439\n269#1:440\n270#1:445\n270#1:446\n183#1:400,4\n184#1:406,4\n207#1:412,4\n208#1:418,4\n375#1:422,2\n386#1:426,4\n387#1:432,4\n217#1:436,3\n269#1:441,4\n270#1:447,4\n281#1:451,3\n*E\n"})
public final class RuleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String CODERIDER_DIR = ".crkilo";
    @NotNull
    private static final String RULES_SUBDIR = "rules";
    @NotNull
    private static final String WORKFLOWS_SUBDIR = "workflows";
    @NotNull
    private static final String RULES_PATH = ".crkilo/rules";
    @NotNull
    private static final String WORKFLOWS_PATH = ".crkilo/workflows";

    public RuleService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * Unable to fully structure code
     */
    public final void createRuleFile(@NotNull String filename, boolean isGlobal, @NotNull String ruleType) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)ruleType, (String)"ruleType");
        if (isGlobal) {
            v0 = System.getProperty("user.home");
            if (v0 == null) {
                v0 = System.getProperty("user.dir");
            }
        } else {
            v0 = this.project.getBasePath();
            if (v0 == null) {
                $this$createRuleFile_u24lambda_u240 = this;
                $i$a$-run-RuleService$createRuleFile$baseDir$1 = false;
                $this$createRuleFile_u24lambda_u240.notify(I18nKt.getMessage("rules.errors.failedToCreateRuleFile"), I18nKt.getMessage("rules.errors.noWorkspaceFound"), NotificationType.WARNING);
                return;
            }
        }
        baseDir = v0;
        v1 = ruleType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
        var6_9 = v1;
        subDir = Intrinsics.areEqual((Object)var6_9, (Object)"workflow") != false || Intrinsics.areEqual((Object)var6_9, (Object)"workflows") != false ? ".crkilo/workflows" : ".crkilo/rules";
        $i$a$-run-RuleService$createRuleFile$baseDir$1 = new char[]{'/', '\\'};
        $this$toTypedArray$iv = (Object[])StringsKt.split$default((CharSequence)subDir, (char[])$i$a$-run-RuleService$createRuleFile$baseDir$1, (boolean)false, (int)0, (int)6, null);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        $this$createRuleFile_u24lambda_u240 = thisCollection$iv.toArray(new String[0]);
        dir = Paths.get(baseDir, Arrays.copyOf($this$createRuleFile_u24lambda_u240, $this$createRuleFile_u24lambda_u240.length));
        Files.createDirectories(dir, new FileAttribute[0]);
        safeName = this.sanitizeFilename(filename);
        filePath = dir.resolve(safeName);
        if (Files.exists(filePath, new LinkOption[0])) {
            v2 = I18nKt.getMessage("rules.errors.failedToCreateRuleFile");
            $i$f$toTypedArray = I18nKt.getMessage("rules.errors.fileAlreadyExists");
            thisCollection$iv = new Object[]{filePath.getFileName().toString()};
            v3 = String.format($i$f$toTypedArray, Arrays.copyOf(thisCollection$iv, thisCollection$iv.length));
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"format(...)");
            this.notify(v2, v3, NotificationType.WARNING);
            return;
        }
        baseFileName = filePath.getFileName().toString();
        if (StringsKt.equals((String)ruleType, (String)"workflow", (boolean)true)) ** GOTO lbl41
        if (StringsKt.equals((String)ruleType, (String)"workflows", (boolean)true)) {
lbl41:
            // 2 sources

            v4 = StringsKt.trim((CharSequence)("# " + baseFileName + "\n\n" + I18nKt.getMessage("rules.templates.workflow.description") + "\n\n" + I18nKt.getMessage("rules.templates.workflow.stepsHeader") + "\n\n1. " + I18nKt.getMessage("rules.templates.workflow.step1") + "\n2. " + I18nKt.getMessage("rules.templates.workflow.step2") + "\n")).toString();
        } else {
            v4 = StringsKt.trim((CharSequence)("# " + baseFileName + "\n\n" + I18nKt.getMessage("rules.templates.rule.description") + "\n\n" + I18nKt.getMessage("rules.templates.rule.guidelinesHeader") + "\n\n- " + I18nKt.getMessage("rules.templates.rule.guideline1") + "\n- " + I18nKt.getMessage("rules.templates.rule.guideline2") + "\n")).toString();
        }
        content = v4;
        Files.writeString(filePath, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
        Intrinsics.checkNotNull((Object)filePath);
        this.openFileInEditor(filePath);
    }

    private final String sanitizeFilename(String input) {
        Object[] it;
        Object object;
        Object $this$sanitizeFilename_u24lambda_u241;
        Object object2 = this;
        try {
            $this$sanitizeFilename_u24lambda_u241 = object2;
            boolean bl = false;
            $this$sanitizeFilename_u24lambda_u241 = Result.constructor-impl((Object)((Object)Paths.get(input, new String[0]).getFileName()).toString());
        }
        catch (Throwable bl) {
            $this$sanitizeFilename_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$sanitizeFilename_u24lambda_u241;
        Object[] objectArray = Result.exceptionOrNull-impl((Object)object2);
        if (objectArray == null) {
            object = object2;
        } else {
            it = objectArray;
            boolean bl = false;
            object = input;
        }
        Object name = (String)object;
        object2 = (CharSequence)name;
        it = new Regex("[<>:\"/\\\\|?*]");
        String string = "_";
        name = it.replace((CharSequence)object2, string);
        object2 = new char[2];
        object2[0] = 46;
        object2[1] = 32;
        name = StringsKt.trimEnd((String)((Object)StringsKt.trim((CharSequence)((CharSequence)name))).toString(), (char[])object2);
        if (StringsKt.isBlank((CharSequence)((CharSequence)name))) {
            name = "rule.md";
        }
        it = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
        Set reserved = SetsKt.setOf((Object[])it);
        String base = StringsKt.substringBefore$default((String)name, (char)'.', null, (int)2, null);
        String string2 = base.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (reserved.contains(string2)) {
            name = "_" + (String)name;
        }
        if (((String)name).length() > 200) {
            name = StringsKt.take((String)name, (int)200);
        }
        return name;
    }

    public final void toggleRule(@NotNull String rulePath, boolean enabled, boolean isGlobal) {
        Intrinsics.checkNotNullParameter((Object)rulePath, (String)"rulePath");
        String key = isGlobal ? "globalRulesToggles" : "localRulesToggles";
        this.updateToggle(key, rulePath, enabled);
    }

    public final void toggleWorkflow(@NotNull String path, boolean enabled, boolean isGlobal) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String key = isGlobal ? "globalWorkflowToggles" : "localWorkflowToggles";
        this.updateToggle(key, path, enabled);
    }

    public final void deleteRuleFile(@NotNull String rulePath) {
        Intrinsics.checkNotNullParameter((Object)rulePath, (String)"rulePath");
        try {
            Path p = Paths.get(rulePath, new String[0]);
            Files.deleteIfExists(p);
            String string = I18nKt.getMessage("rules.actions.deleted");
            Object[] objectArray = new Object[]{((Object)p.getFileName()).toString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            this.notify(string2, "", NotificationType.INFORMATION);
        }
        catch (Exception e) {
            String string = I18nKt.getMessage("rules.errors.failedToDeleteRuleFile");
            String string3 = e.getMessage();
            if (string3 == null) {
                string3 = "Unknown error";
            }
            this.notify(string, string3, NotificationType.ERROR);
        }
    }

    @NotNull
    public final JsonObject buildRulesData() {
        String[] globalWorkflowsDir;
        String[] stringArray;
        String base = this.project.getBasePath();
        String home = System.getProperty("user.home");
        JsonObject payload = new JsonObject();
        payload.addProperty("type", "rulesData");
        if (home != null) {
            String[] stringArray2 = new String[]{CODERIDER_DIR, RULES_SUBDIR};
            Path globalRulesDir = Paths.get(home, stringArray2);
            stringArray = new String[]{CODERIDER_DIR, WORKFLOWS_SUBDIR};
            globalWorkflowsDir = Paths.get(home, stringArray);
            Gson gson = new Gson();
            Intrinsics.checkNotNull((Object)globalRulesDir);
            payload.add("globalRules", gson.toJsonTree(this.getEnabledRulesFromDirectory(globalRulesDir, "globalRulesToggles")));
            Gson gson2 = new Gson();
            Intrinsics.checkNotNull((Object)globalWorkflowsDir);
            payload.add("globalWorkflows", gson2.toJsonTree(this.getEnabledRulesFromDirectory((Path)globalWorkflowsDir, "globalWorkflowToggles")));
        } else {
            payload.add("globalRules", new Gson().toJsonTree((Object)MapsKt.emptyMap()));
            payload.add("globalWorkflows", new Gson().toJsonTree((Object)MapsKt.emptyMap()));
        }
        if (base != null) {
            globalWorkflowsDir = new String[]{CODERIDER_DIR, RULES_SUBDIR};
            Path localRulesDir = Paths.get(base, globalWorkflowsDir);
            stringArray = new String[]{CODERIDER_DIR, WORKFLOWS_SUBDIR};
            Path localWorkflowsDir = Paths.get(base, stringArray);
            Gson gson = new Gson();
            Intrinsics.checkNotNull((Object)localRulesDir);
            payload.add("localRules", gson.toJsonTree(this.getEnabledRulesFromDirectory(localRulesDir, "localRulesToggles")));
            Gson gson3 = new Gson();
            Intrinsics.checkNotNull((Object)localWorkflowsDir);
            payload.add("localWorkflows", gson3.toJsonTree(this.getEnabledRulesFromDirectory(localWorkflowsDir, "localWorkflowToggles")));
        } else {
            payload.add("localRules", new Gson().toJsonTree((Object)MapsKt.emptyMap()));
            payload.add("localWorkflows", new Gson().toJsonTree((Object)MapsKt.emptyMap()));
        }
        return payload;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateToggle(String key, String path, boolean enabled) {
        try {
            Object object;
            Gson gson;
            PropertiesComponent props;
            block11: {
                block8: {
                    props = PropertiesComponent.getInstance();
                    gson = new Gson();
                    String json = props.getValue(key);
                    Object object2 = json;
                    if (object2 == null || StringsKt.isBlank((CharSequence)object2)) break block8;
                    try {
                        Map map;
                        block10: {
                            block9: {
                                void $this$mapValuesTo$iv$iv;
                                void $this$mapValues$iv;
                                Object object3;
                                Object object4;
                                Object object5;
                                void $this$mapKeysTo$iv$iv;
                                map = (Map)gson.fromJson(json, Map.class);
                                if (map == null) break block9;
                                Map $this$mapKeys$iv = map;
                                boolean $i$f$mapKeys22 = false;
                                Map map2 = $this$mapKeys$iv;
                                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                                boolean $i$f$mapKeysTo = false;
                                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                                boolean $i$f$associateByTo = false;
                                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                                    void it$iv$iv;
                                    Object it;
                                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                                    object5 = destination$iv$iv;
                                    boolean bl = false;
                                    object4 = (Map.Entry)element$iv$iv$iv;
                                    String string = String.valueOf(it.getKey());
                                    object3 = object5;
                                    boolean bl2 = false;
                                    it = it$iv$iv.getValue();
                                    object3.put(string, it);
                                }
                                Map $i$f$mapKeys22 = destination$iv$iv;
                                boolean $i$f$mapValues = false;
                                destination$iv$iv = $this$mapValues$iv;
                                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                                boolean $i$f$mapValuesTo = false;
                                Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
                                boolean $i$f$associateByTo2 = false;
                                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                                    void it;
                                    void it$iv$iv;
                                    Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                                    object4 = destination$iv$iv2;
                                    boolean bl3 = false;
                                    object3 = (Map.Entry)element$iv$iv$iv;
                                    Object k = it$iv$iv.getKey();
                                    object5 = object4;
                                    boolean bl4 = false;
                                    Object v = it.getValue();
                                    Boolean bl5 = v instanceof Boolean ? (Boolean)v : null;
                                    Boolean bl6 = bl5 != null ? bl5 : true;
                                    object5.put(k, bl6);
                                }
                                map = MapsKt.toMutableMap((Map)destination$iv$iv2);
                                if (map != null) break block10;
                            }
                            map = new LinkedHashMap();
                        }
                        object2 = map;
                    }
                    catch (Exception exception) {
                        object2 = new LinkedHashMap();
                    }
                    object = object2;
                    break block11;
                }
                object = new LinkedHashMap();
            }
            Map map = object;
            Boolean bl = enabled;
            map.put(path, bl);
            props.setValue(key, gson.toJson((Object)map));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<String, Boolean> getEnabledRulesFromDirectory(Path dir, String toggleKey) {
        Object object;
        Map result2 = new LinkedHashMap();
        if (!Files.exists(dir, new LinkOption[0])) {
            return result2;
        }
        Object[] objectArray = new String[]{".md", ".txt"};
        Set allowed = SetsKt.setOf((Object[])objectArray);
        PropertiesComponent props = PropertiesComponent.getInstance();
        Gson gson = new Gson();
        String json = props.getValue(toggleKey);
        Object object2 = json;
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            try {
                Map map;
                Map map2 = (Map)gson.fromJson(json, Map.class);
                if (map2 != null) {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Object object3;
                    Object object4;
                    Object object5;
                    void $this$mapKeysTo$iv$iv;
                    Map $this$mapKeys$iv = map2;
                    boolean $i$f$mapKeys22 = false;
                    Map map3 = $this$mapKeys$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                    boolean $i$f$mapKeysTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Object it;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        object5 = destination$iv$iv;
                        boolean bl = false;
                        object4 = (Map.Entry)element$iv$iv$iv;
                        String string = String.valueOf(it.getKey());
                        object3 = object5;
                        boolean bl2 = false;
                        it = it$iv$iv.getValue();
                        object3.put(string, it);
                    }
                    Map $i$f$mapKeys22 = destination$iv$iv;
                    boolean $i$f$mapValues = false;
                    destination$iv$iv = $this$mapValues$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo2 = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                        void it;
                        void it$iv$iv;
                        Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                        object4 = destination$iv$iv2;
                        boolean bl3 = false;
                        object3 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        object5 = object4;
                        boolean bl4 = false;
                        Object v = it.getValue();
                        Boolean bl5 = v instanceof Boolean ? (Boolean)v : null;
                        Boolean bl6 = bl5 != null ? bl5 : true;
                        object5.put(k, bl6);
                    }
                    map = destination$iv$iv2;
                } else {
                    map = MapsKt.emptyMap();
                }
                object2 = map;
            }
            catch (Exception exception) {
                object2 = MapsKt.emptyMap();
            }
            object = object2;
        } else {
            object = MapsKt.emptyMap();
        }
        Map toggles = object;
        try {
            object2 = Files.list(dir);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)object2;
                boolean bl = false;
                stream.filter(arg_0 -> RuleService.getEnabledRulesFromDirectory$lambda$14$lambda$8(RuleService::getEnabledRulesFromDirectory$lambda$14$lambda$7, arg_0)).filter(arg_0 -> RuleService.getEnabledRulesFromDirectory$lambda$14$lambda$11(arg_0 -> RuleService.getEnabledRulesFromDirectory$lambda$14$lambda$10(allowed, arg_0), arg_0)).forEach(arg_0 -> RuleService.getEnabledRulesFromDirectory$lambda$14$lambda$13(arg_0 -> RuleService.getEnabledRulesFromDirectory$lambda$14$lambda$12(result2, toggles, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result2;
    }

    private final void openFileInEditor(Path filePath) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> RuleService.openFileInEditor$lambda$16(filePath, this));
    }

    private final void notify(String title, String content2, NotificationType type2) {
        ApplicationManager.getApplication().invokeLater(() -> RuleService.notify$lambda$17(title, content2, type2, this));
    }

    @NotNull
    public final String buildRulesAndWorkflowsSection() {
        StringBuilder stringBuilder;
        Iterable<Path> globalWorkflows;
        Iterable<Path> globalRules;
        List<String> localWorkflows;
        List<String> localRules;
        block16: {
            Iterable<Path> iterable;
            block15: {
                Path globalWorkflowsDir;
                String home;
                block14: {
                    Iterable<Path> iterable2;
                    block13: {
                        Path path;
                        Path globalRulesDir;
                        String string = this.project.getBasePath();
                        if (string == null) {
                            return "";
                        }
                        String base = string;
                        String string2 = System.getProperty("user.home");
                        if (string2 == null) {
                            string2 = "";
                        }
                        home = string2;
                        String[] stringArray = new String[]{CODERIDER_DIR, RULES_SUBDIR};
                        Path localRulesDir = Paths.get(base, stringArray);
                        String[] stringArray2 = new String[]{CODERIDER_DIR, WORKFLOWS_SUBDIR};
                        Path localWorkflowsDir = Paths.get(base, stringArray2);
                        if (!StringsKt.isBlank((CharSequence)home)) {
                            String[] stringArray3 = new String[]{CODERIDER_DIR, RULES_SUBDIR};
                            v2 = Paths.get(home, stringArray3);
                        } else {
                            v2 = globalRulesDir = null;
                        }
                        if (!StringsKt.isBlank((CharSequence)home)) {
                            String[] stringArray4 = new String[]{CODERIDER_DIR, WORKFLOWS_SUBDIR};
                            path = Paths.get(home, stringArray4);
                        } else {
                            path = null;
                        }
                        globalWorkflowsDir = path;
                        Intrinsics.checkNotNull((Object)localRulesDir);
                        Path path2 = Paths.get(base, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                        localRules = RuleService.buildRulesAndWorkflowsSection$readDir(this, localRulesDir, path2, RuleService.buildRulesAndWorkflowsSection$loadToggles("localRulesToggles"));
                        Intrinsics.checkNotNull((Object)localWorkflowsDir);
                        Path path3 = Paths.get(base, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                        localWorkflows = RuleService.buildRulesAndWorkflowsSection$readDir(this, localWorkflowsDir, path3, RuleService.buildRulesAndWorkflowsSection$loadToggles("localWorkflowToggles"));
                        iterable2 = globalRulesDir;
                        if (iterable2 == null) break block13;
                        Path it = iterable2;
                        boolean bl = false;
                        Path path4 = Paths.get(home, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                        List<String> list = RuleService.buildRulesAndWorkflowsSection$readDir(this, it, path4, RuleService.buildRulesAndWorkflowsSection$loadToggles("globalRulesToggles"));
                        iterable2 = list;
                        if (list != null) break block14;
                    }
                    iterable2 = globalRules = CollectionsKt.emptyList();
                }
                if ((iterable = globalWorkflowsDir) == null) break block15;
                Path it = iterable;
                boolean bl = false;
                Path path = Paths.get(home, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                List<String> list = RuleService.buildRulesAndWorkflowsSection$readDir(this, it, path, RuleService.buildRulesAndWorkflowsSection$loadToggles("globalWorkflowToggles"));
                iterable = list;
                if (list != null) break block16;
            }
            iterable = globalWorkflows = CollectionsKt.emptyList();
        }
        if (localRules.isEmpty() && localWorkflows.isEmpty() && globalRules.isEmpty() && globalWorkflows.isEmpty()) {
            return "";
        }
        StringBuilder $this$buildRulesAndWorkflowsSection_u24lambda_u2431 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildRulesAndWorkflowsSection_u24lambda_u2431.append('\n');
        $this$buildRulesAndWorkflowsSection_u24lambda_u2431.append("====").append('\n');
        $this$buildRulesAndWorkflowsSection_u24lambda_u2431.append('\n');
        $this$buildRulesAndWorkflowsSection_u24lambda_u2431.append("PROJECT RULES & WORKFLOWS").append('\n');
        $this$buildRulesAndWorkflowsSection_u24lambda_u2431.append('\n');
        RuleService.buildRulesAndWorkflowsSection$lambda$31$emit($this$buildRulesAndWorkflowsSection_u24lambda_u2431, "Global Rules", globalRules);
        RuleService.buildRulesAndWorkflowsSection$lambda$31$emit($this$buildRulesAndWorkflowsSection_u24lambda_u2431, "Local Rules", localRules);
        RuleService.buildRulesAndWorkflowsSection$lambda$31$emit($this$buildRulesAndWorkflowsSection_u24lambda_u2431, "Global Workflows", globalWorkflows);
        RuleService.buildRulesAndWorkflowsSection$lambda$31$emit($this$buildRulesAndWorkflowsSection_u24lambda_u2431, "Local Workflows", localWorkflows);
        return stringBuilder.toString();
    }

    @Nullable
    public final String buildExplicitInstructionsForWorkflow(@NotNull String cwd, @NotNull String commandName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        Path path = this.findEnabledWorkflow(cwd, commandName);
        if (path == null) {
            return null;
        }
        Path workflow = path;
        Object object2 = this;
        try {
            RuleService $this$buildExplicitInstructionsForWorkflow_u24lambda_u2432 = object2;
            boolean bl = false;
            String string = Files.readString(workflow, StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
            object = Result.constructor-impl((Object)((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = "";
        String content2 = (String)(Result.isFailure-impl((Object)object2) ? object : object2);
        if (((CharSequence)content2).length() == 0) {
            return null;
        }
        String fileName = ((Object)workflow.getFileName()).toString();
        return "<explicit_instructions type=\"" + fileName + "\">\n" + content2 + "\n</explicit_instructions>\n";
    }

    private final Path findEnabledWorkflow(String cwd, String commandName) {
        Object v2;
        block4: {
            List list;
            Path path;
            String string = System.getProperty("user.home");
            if (string == null) {
                string = "";
            }
            String home = string;
            String[] stringArray = new String[]{CODERIDER_DIR, WORKFLOWS_SUBDIR};
            Path localDir = Paths.get(cwd, stringArray);
            if (((CharSequence)home).length() > 0) {
                String[] stringArray2 = new String[]{CODERIDER_DIR, WORKFLOWS_SUBDIR};
                path = Paths.get(home, stringArray2);
            } else {
                path = null;
            }
            Path globalDir = path;
            Map<String, Boolean> localToggles = this.loadWorkflowToggles("localWorkflowToggles");
            Map<String, Boolean> globalToggles = this.loadWorkflowToggles("globalWorkflowToggles");
            List $this$findEnabledWorkflow_u24lambda_u2440 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$findEnabledWorkflow_u24lambda_u2440.addAll((Collection)RuleService.findEnabledWorkflow$enumerate(localDir, localToggles));
            $this$findEnabledWorkflow_u24lambda_u2440.addAll((Collection)RuleService.findEnabledWorkflow$enumerate(globalDir, globalToggles));
            List candidates = CollectionsKt.build((List)list);
            Iterable $this$firstOrNull$iv = candidates;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path p = (Path)element$iv;
                boolean bl2 = false;
                String fileName = ((Object)p.getFileName()).toString();
                String base = StringsKt.substringBeforeLast((String)fileName, (char)'.', (String)fileName);
                if (!(Intrinsics.areEqual((Object)commandName, (Object)base) || Intrinsics.areEqual((Object)commandName, (Object)fileName))) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Boolean> loadWorkflowToggles(String key) {
        Map map;
        try {
            Map map2;
            String json = PropertiesComponent.getInstance().getValue(key);
            Object object = json;
            if (object == null || StringsKt.isBlank((CharSequence)object)) {
                map2 = MapsKt.emptyMap();
            } else {
                object = (Map)new Gson().fromJson(json, Map.class);
                if (object != null) {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Object object2;
                    Object object3;
                    Object object4;
                    void $this$mapKeysTo$iv$iv;
                    void $this$mapKeys$iv;
                    Object object5 = object;
                    boolean $i$f$mapKeys22 = false;
                    void var6_8 = $this$mapKeys$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                    boolean $i$f$mapKeysTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Object it;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        object4 = destination$iv$iv;
                        boolean bl = false;
                        object3 = (Map.Entry)element$iv$iv$iv;
                        String string = String.valueOf(it.getKey());
                        object2 = object4;
                        boolean bl2 = false;
                        it = it$iv$iv.getValue();
                        object2.put(string, it);
                    }
                    Map $i$f$mapKeys22 = destination$iv$iv;
                    boolean $i$f$mapValues = false;
                    destination$iv$iv = $this$mapValues$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo2 = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                        void it;
                        void it$iv$iv;
                        Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                        object3 = destination$iv$iv2;
                        boolean bl3 = false;
                        object2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        object4 = object3;
                        boolean bl4 = false;
                        Object v = it.getValue();
                        Boolean bl5 = v instanceof Boolean ? (Boolean)v : null;
                        Boolean bl6 = bl5 != null ? bl5 : true;
                        object4.put(k, bl6);
                    }
                    map2 = destination$iv$iv2;
                } else {
                    map2 = MapsKt.emptyMap();
                }
            }
            map = map2;
        }
        catch (Exception exception) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private static final boolean getEnabledRulesFromDirectory$lambda$14$lambda$7(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean getEnabledRulesFromDirectory$lambda$14$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getEnabledRulesFromDirectory$lambda$14$lambda$10(Set $allowed, Path p) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $allowed;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String ext = (String)element$iv;
                    boolean bl2 = false;
                    String string = ((Object)p.getFileName()).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)ext, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean getEnabledRulesFromDirectory$lambda$14$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit getEnabledRulesFromDirectory$lambda$14$lambda$12(Map $result, Map $toggles, Path p) {
        String pathStr = ((Object)p).toString();
        Map map = $result;
        Boolean bl = (Boolean)$toggles.get(pathStr);
        Boolean bl2 = bl != null ? bl : true;
        map.put(pathStr, bl2);
        return Unit.INSTANCE;
    }

    private static final void getEnabledRulesFromDirectory$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void openFileInEditor$lambda$16$lambda$15(RuleService this$0, VirtualFile $vFile) {
        try {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this$0.project, $vFile);
            FileEditorManager.getInstance((Project)this$0.project).openTextEditor(descriptor, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void openFileInEditor$lambda$16(Path $filePath, RuleService this$0) {
        try {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile($filePath);
            if (vFile != null) {
                VirtualFile[] virtualFileArray = new VirtualFile[]{vFile};
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
                ApplicationManager.getApplication().invokeLater(() -> RuleService.openFileInEditor$lambda$16$lambda$15(this$0, vFile));
            } else {
                VirtualFileManager.getInstance().asyncRefresh(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void notify$lambda$17(String $title, String $content, NotificationType $type, RuleService this$0) {
        NotificationGroupManager.getInstance().getNotificationGroup("CodeRider-Kilo").createNotification($title, $content, $type).notify(this$0.project);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Boolean> buildRulesAndWorkflowsSection$loadToggles(String key) {
        Object object;
        PropertiesComponent props = PropertiesComponent.getInstance();
        String json = props.getValue(key);
        Object object2 = json;
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            try {
                Map map;
                object2 = (Map)new Gson().fromJson(json, Map.class);
                if (object2 != null) {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Object object3;
                    Object object4;
                    Object object5;
                    void $this$mapKeysTo$iv$iv;
                    void $this$mapKeys$iv;
                    Object object6 = object2;
                    boolean $i$f$mapKeys22 = false;
                    void var7_7 = $this$mapKeys$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                    boolean $i$f$mapKeysTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Object it;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        object5 = destination$iv$iv;
                        boolean bl = false;
                        object4 = (Map.Entry)element$iv$iv$iv;
                        String string = String.valueOf(it.getKey());
                        object3 = object5;
                        boolean bl2 = false;
                        it = it$iv$iv.getValue();
                        object3.put(string, it);
                    }
                    Map $i$f$mapKeys22 = destination$iv$iv;
                    boolean $i$f$mapValues = false;
                    destination$iv$iv = $this$mapValues$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo2 = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                        void it;
                        void it$iv$iv;
                        Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                        object4 = destination$iv$iv2;
                        boolean bl3 = false;
                        object3 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        object5 = object4;
                        boolean bl4 = false;
                        Object v = it.getValue();
                        Boolean bl5 = v instanceof Boolean ? (Boolean)v : null;
                        Boolean bl6 = bl5 != null ? bl5 : true;
                        object5.put(k, bl6);
                    }
                    map = destination$iv$iv2;
                } else {
                    map = MapsKt.emptyMap();
                }
                object2 = map;
            }
            catch (Exception exception) {
                object2 = MapsKt.emptyMap();
            }
            object = object2;
        } else {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private static final boolean buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$20(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$21(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$23(Set $allowed, Path p) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $allowed;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String ext = (String)element$iv;
                    boolean bl2 = false;
                    String string = ((Object)p.getFileName()).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)ext, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$24(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$26(Map $toggles, Path $baseForRel, RuleService this$0, List $results, Path p) {
        Object object;
        String abs = ((Object)p.toAbsolutePath().normalize()).toString();
        if ($toggles.containsKey(abs) && Intrinsics.areEqual($toggles.get(abs), (Object)false)) {
            return Unit.INSTANCE;
        }
        String rel = ((Object)$baseForRel.relativize(p.toAbsolutePath().normalize())).toString();
        Object object2 = this$0;
        try {
            RuleService $this$buildRulesAndWorkflowsSection_u24readDir_u24lambda_u2428_u24lambda_u2426_u24lambda_u2425 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Files.readString(p, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = "";
        Object object3 = Result.isFailure-impl((Object)object2) ? object : object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getOrDefault(...)");
        String content2 = ((Object)StringsKt.trim((CharSequence)((String)object3))).toString();
        if (((CharSequence)content2).length() > 0) {
            String trimmed = content2.length() > 1000 ? StringsKt.take((String)content2, (int)1000) : content2;
            ((Collection)$results).add(rel + "\n" + trimmed);
        }
        return Unit.INSTANCE;
    }

    private static final void buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$27(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> buildRulesAndWorkflowsSection$readDir(RuleService this$0, Path dir, Path baseForRel, Map<String, Boolean> toggles) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = new String[]{".md", ".txt"};
        Set allowed = SetsKt.setOf((Object[])objectArray);
        List results = new ArrayList();
        try {
            AutoCloseable autoCloseable = Files.list(dir);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                stream.filter(arg_0 -> RuleService.buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$21(RuleService::buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$20, arg_0)).filter(arg_0 -> RuleService.buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$24(arg_0 -> RuleService.buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$23(allowed, arg_0), arg_0)).forEach(arg_0 -> RuleService.buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$27(arg_0 -> RuleService.buildRulesAndWorkflowsSection$readDir$lambda$28$lambda$26(toggles, baseForRel, this$0, results, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    private static final void buildRulesAndWorkflowsSection$lambda$31$emit(StringBuilder $this_buildString, String title, List<String> items) {
        if (items.isEmpty()) {
            return;
        }
        $this_buildString.append("# " + title).append('\n');
        $this_buildString.append('\n');
        $this_buildString.append(CollectionsKt.joinToString$default((Iterable)items, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null)).append('\n');
        $this_buildString.append('\n');
    }

    private static final boolean findEnabledWorkflow$enumerate$lambda$39$lambda$33(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean findEnabledWorkflow$enumerate$lambda$39$lambda$34(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findEnabledWorkflow$enumerate$lambda$39$lambda$35(Map $toggles, Path p) {
        String string = ((Object)p.getFileName()).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String name = string;
        if (!StringsKt.endsWith$default((String)name, (String)".md", (boolean)false, (int)2, null)) {
            if (!StringsKt.endsWith$default((String)name, (String)".txt", (boolean)false, (int)2, null)) return false;
        }
        Boolean bl = (Boolean)$toggles.get(((Object)p.toAbsolutePath().normalize()).toString());
        if (bl == null) return true;
        boolean bl2 = bl;
        if (!bl2) return false;
        return true;
    }

    private static final boolean findEnabledWorkflow$enumerate$lambda$39$lambda$36(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit findEnabledWorkflow$enumerate$lambda$39$lambda$37(List $out, Path it) {
        Intrinsics.checkNotNull((Object)it);
        $out.add(it);
        return Unit.INSTANCE;
    }

    private static final void findEnabledWorkflow$enumerate$lambda$39$lambda$38(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Path> findEnabledWorkflow$enumerate(Path dir, Map<String, Boolean> toggles) {
        if (dir == null || !Files.exists(dir, new LinkOption[0])) {
            return CollectionsKt.emptyList();
        }
        List out = new ArrayList();
        try {
            AutoCloseable autoCloseable = Files.list(dir);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                stream.filter(arg_0 -> RuleService.findEnabledWorkflow$enumerate$lambda$39$lambda$34(RuleService::findEnabledWorkflow$enumerate$lambda$39$lambda$33, arg_0)).filter(arg_0 -> RuleService.findEnabledWorkflow$enumerate$lambda$39$lambda$36(arg_0 -> RuleService.findEnabledWorkflow$enumerate$lambda$39$lambda$35(toggles, arg_0), arg_0)).forEach(arg_0 -> RuleService.findEnabledWorkflow$enumerate$lambda$39$lambda$38(arg_0 -> RuleService.findEnabledWorkflow$enumerate$lambda$39$lambda$37(out, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/rules/RuleService$Companion;", "", "<init>", "()V", "CODERIDER_DIR", "", "RULES_SUBDIR", "WORKFLOWS_SUBDIR", "RULES_PATH", "WORKFLOWS_PATH", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

