/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.marketplace;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.composer.marketplace.InstallMarketplaceItemOptions;
import cn.gitlab.kilo.jetbrains.composer.marketplace.MarketplaceInstalledMetadata;
import cn.gitlab.kilo.jetbrains.composer.marketplace.MarketplaceItem;
import cn.gitlab.kilo.jetbrains.composer.marketplace.MarketplaceItemsResponse;
import cn.gitlab.kilo.jetbrains.composer.marketplace.MarketplaceManager;
import cn.gitlab.kilo.jetbrains.composer.marketplace.RemoteConfigLoader;
import cn.gitlab.kilo.jetbrains.composer.mcp.McpHub;
import cn.gitlab.kilo.jetbrains.composer.mode.ComposerMode;
import cn.gitlab.kilo.jetbrains.composer.mode.ComposerModeManager;
import com.google.gson.Gson;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u000eJ \u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u0012H\u0002J \u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u0012H\u0002J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u001a\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00132\b\b\u0002\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "configLoader", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader;", "gson", "Lcom/google/gson/Gson;", "getMarketplaceItems", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceItemsResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getInstallationMetadata", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceInstalledMetadata;", "checkProjectInstallations", "", "", "checkGlobalInstallations", "installItem", "item", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceItem;", "options", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/InstallMarketplaceItemOptions;", "(Lcn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceItem;Lcn/gitlab/kilo/jetbrains/composer/marketplace/InstallMarketplaceItemOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "installMarketplaceItem", "removeItem", "", "cleanup", "notify", "message", "isError", "", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMarketplaceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplaceManager.kt\ncn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n31#2,2:302\n31#2,2:308\n1869#3,2:304\n1869#3,2:306\n1869#3,2:310\n1869#3,2:312\n*S KotlinDebug\n*F\n+ 1 MarketplaceManager.kt\ncn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceManager\n*L\n103#1:302,2\n150#1:308,2\n105#1:304,2\n121#1:306,2\n152#1:310,2\n168#1:312,2\n*E\n"})
public final class MarketplaceManager {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final RemoteConfigLoader configLoader;
    @NotNull
    private final Gson gson;

    public MarketplaceManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.logger = Logger.Companion.getInstance("MarketplaceManager");
        this.configLoader = new RemoteConfigLoader();
        this.gson = new Gson();
    }

    @Nullable
    public final Object getMarketplaceItems(@NotNull Continuation<? super MarketplaceItemsResponse> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MarketplaceItemsResponse>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ MarketplaceManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        errors = new ArrayList<E>();
                        orgSettings = null;
                        hideMarketplaceMcps = false;
                        this.L$0 = errors;
                        this.label = 1;
                        v0 = MarketplaceManager.access$getConfigLoader$p(this.this$0).loadAllItems(false, (Continuation<? super List<MarketplaceItem>>)((Continuation)this));
                        ** if (v0 != var17_2) goto lbl15
lbl14:
                        // 1 sources

                        return var17_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        orgSettings = null;
                        errors = (List<E>)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            allMarketplaceItems = (List)v0;
                            organizationMcps = CollectionsKt.emptyList();
                            marketplaceItems = allMarketplaceItems;
                            var8_14 = organizationMcps;
                            var9_15 = marketplaceItems;
                            var10_16 = ((Collection)errors).isEmpty() == false != false ? errors : null;
                            var2_3 = new MarketplaceItemsResponse(var9_15, var8_14, (List<String>)var10_16);
                        }
                        catch (Exception e) {
                            MarketplaceManager.access$getLogger$p(this.this$0).error("Failed to load marketplace items", e);
                            var4_8 = CollectionsKt.emptyList();
                            var5_10 = CollectionsKt.emptyList();
                            v1 = e.getMessage();
                            if (v1 == null) {
                                v1 = "Unknown error";
                            }
                            var6_12 = CollectionsKt.listOf((Object)v1);
                            var2_3 = new MarketplaceItemsResponse(var5_10, var4_8, var6_12);
                        }
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super MarketplaceItemsResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object getInstallationMetadata(@NotNull Continuation<? super MarketplaceInstalledMetadata> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MarketplaceInstalledMetadata>, Object>(this, null){
            int label;
            final /* synthetic */ MarketplaceManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MarketplaceInstalledMetadata metadata = new MarketplaceInstalledMetadata(MarketplaceManager.access$checkProjectInstallations(this.this$0), MarketplaceManager.access$checkGlobalInstallations(this.this$0));
                        return metadata;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super MarketplaceInstalledMetadata> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Map<String, Map<String, String>> checkProjectInstallations() {
        Map metadata;
        block12: {
            metadata = new LinkedHashMap();
            try {
                Path projectMcpPath;
                Object modes;
                String string = this.project.getBasePath();
                if (string == null) {
                    return metadata;
                }
                String projectBasePath = string;
                String[] stringArray = new String[]{".crkilomodes"};
                Path projectModesPath = Paths.get(projectBasePath, stringArray);
                if (Files.exists(projectModesPath, new LinkOption[0])) {
                    try {
                        ComponentManager $this$service$iv = (ComponentManager)this.project;
                        boolean $i$f$service = false;
                        Class<ComposerModeManager> serviceClass$iv = ComposerModeManager.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        ComposerModeManager modesManager = (ComposerModeManager)object;
                        modes = modesManager.getAllCustomModes();
                        Iterable $this$forEach$iv = (Iterable)modes;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ComposerMode mode = (ComposerMode)element$iv;
                            boolean bl = false;
                            metadata.put(mode.getSlug(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"mode")));
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to read project modes", e);
                    }
                }
                if (!Files.exists(projectMcpPath = Paths.get(projectBasePath, modes = new String[]{".kilocode", "mcp.json"}), new LinkOption[0])) break block12;
                try {
                    String content2 = Files.readString(projectMcpPath);
                    Map data = (Map)this.gson.fromJson(content2, Map.class);
                    Intrinsics.checkNotNull((Object)data);
                    Iterator<Object> iterator = data.get("mcpServers");
                    Map mcpServers2 = iterator instanceof Map ? (Map)((Object)iterator) : null;
                    Object object = mcpServers2;
                    if (object != null && (object = object.keySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String serverName = (String)element$iv;
                            boolean bl = false;
                            metadata.put(serverName, MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"mcp")));
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Failed to read project MCP config", e);
                }
            }
            catch (Exception e) {
                this.logger.error("Error checking project installations", e);
            }
        }
        return metadata;
    }

    private final Map<String, Map<String, String>> checkGlobalInstallations() {
        Map metadata;
        block11: {
            metadata = new LinkedHashMap();
            try {
                Path globalMcpPath;
                String userHome = System.getProperty("user.home");
                String[] stringArray = new String[]{".kilocode"};
                Path globalSettingsPath = Paths.get(userHome, stringArray);
                Path globalModesPath = globalSettingsPath.resolve("customModes.yml");
                if (Files.exists(globalModesPath, new LinkOption[0])) {
                    try {
                        ComponentManager $this$service$iv = (ComponentManager)this.project;
                        boolean $i$f$service = false;
                        Class<ComposerModeManager> serviceClass$iv = ComposerModeManager.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        ComposerModeManager modesManager = (ComposerModeManager)object;
                        List<ComposerMode> modes = modesManager.getAllCustomModes();
                        Iterable $this$forEach$iv = modes;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ComposerMode mode = (ComposerMode)element$iv;
                            boolean bl = false;
                            metadata.put(mode.getSlug(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"mode")));
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to read global modes", e);
                    }
                }
                if (!Files.exists(globalMcpPath = globalSettingsPath.resolve("mcp.json"), new LinkOption[0])) break block11;
                try {
                    String content2 = Files.readString(globalMcpPath);
                    Map data = (Map)this.gson.fromJson(content2, Map.class);
                    Intrinsics.checkNotNull((Object)data);
                    Object v = data.get("mcpServers");
                    Map mcpServers2 = v instanceof Map ? (Map)v : null;
                    Object object = mcpServers2;
                    if (object != null && (object = object.keySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String serverName = (String)element$iv;
                            boolean bl = false;
                            metadata.put(serverName, MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"mcp")));
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Failed to read global MCP config", e);
                }
            }
            catch (Exception e) {
                this.logger.error("Error checking global installations", e);
            }
        }
        return metadata;
    }

    @Nullable
    public final Object installItem(@NotNull MarketplaceItem item, @NotNull InstallMarketplaceItemOptions options, @NotNull Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(item, this, options, null){
            int label;
            final /* synthetic */ MarketplaceItem $item;
            final /* synthetic */ MarketplaceManager this$0;
            final /* synthetic */ InstallMarketplaceItemOptions $options;
            {
                this.$item = $item;
                this.this$0 = $receiver;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block9: {
                    block10: {
                        var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                v0 = this.$item.getType().toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
                                var2_3 = v0;
                                if (!Intrinsics.areEqual((Object)var2_3, (Object)"mcp")) break;
                                $this$service$iv = (ComponentManager)MarketplaceManager.access$getProject$p(this.this$0);
                                $i$f$service = false;
                                serviceClass$iv = McpHub.class;
                                v1 = $this$service$iv.getService(serviceClass$iv);
                                if (v1 == null) {
                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                }
                                hub = (McpHub)v1;
                                this.label = 1;
                                v2 = hub.installMarketplaceMcp(this.$item, this.$options.getTarget(), this.$options.getParameters(), (Continuation<? super String>)((Continuation)this));
                                if (v2 == var7_2) {
                                    return var7_2;
                                }
                                ** GOTO lbl24
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl24:
                                // 2 sources

                                v3 = file = (String)v2;
                                break block9;
                            }
                        }
                        if (!Intrinsics.areEqual((Object)var2_3, (Object)"mode")) break block10;
                        $this$service$iv = (ComponentManager)MarketplaceManager.access$getProject$p(this.this$0);
                        $i$f$service = false;
                        serviceClass$iv = ComposerModeManager.class;
                        v4 = $this$service$iv.getService(serviceClass$iv);
                        if (v4 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        modeManager = (ComposerModeManager)v4;
                        this.label = 2;
                        v5 = modeManager.installMarketplaceMode(this.$item, this.$options.getTarget(), this.$options.getParameters(), (Continuation<? super String>)((Continuation)this));
                        if (v5 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl42
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
lbl42:
                                // 2 sources

                                v3 = file = (String)v5;
                                break block9;
                            }
                        }
                    }
                    throw new IllegalArgumentException("Unsupported item type: " + this.$item.getType());
                }
                return v3;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object installMarketplaceItem(@NotNull MarketplaceItem item, @Nullable InstallMarketplaceItemOptions options, @NotNull Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(options, this, item, null){
            int label;
            final /* synthetic */ InstallMarketplaceItemOptions $options;
            final /* synthetic */ MarketplaceManager this$0;
            final /* synthetic */ MarketplaceItem $item;
            {
                this.$options = $options;
                this.this$0 = $receiver;
                this.$item = $item;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.$options;
                        if (v0 == null) {
                            v0 = new InstallMarketplaceItemOptions(null, null, 3, null);
                        }
                        resolved = v0;
                        this.label = 1;
                        v1 = this.this$0.installItem(this.$item, resolved, (Continuation<? super String>)((Continuation)this));
                        ** if (v1 != var6_2) goto lbl15
lbl14:
                        // 1 sources

                        return var6_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl21
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            filePath = (String)v1;
                            ApplicationManager.getApplication().executeOnPooledThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$1(java.lang.String cn.gitlab.kilo.jetbrains.composer.marketplace.MarketplaceManager ), ()V)((String)filePath, (MarketplaceManager)this.this$0));
                        }
                        catch (Exception e) {
                            v2 = e.getMessage();
                            if (v2 == null) {
                                v2 = "Unknown error";
                            }
                            message = v2;
                            MarketplaceManager.access$notify(this.this$0, "Failed to install " + this.$item.getName() + ": " + message, true);
                            throw e;
                        }
                        return var3_4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$1$lambda$0(MarketplaceManager this$0, VirtualFile $vFile, String $filePath) {
                try {
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(MarketplaceManager.access$getProject$p(this$0), $vFile);
                    FileEditorManager.getInstance((Project)MarketplaceManager.access$getProject$p(this$0)).openTextEditor(descriptor, true);
                }
                catch (Exception e) {
                    MarketplaceManager.notify$default(this$0, "Cannot open settings file: " + $filePath, false, 2, null);
                }
            }

            private static final void invokeSuspend$lambda$1(String $filePath, MarketplaceManager this$0) {
                try {
                    Path nioPath = Paths.get($filePath, new String[0]);
                    VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(nioPath);
                    if (vFile != null) {
                        VirtualFile[] virtualFileArray = new VirtualFile[]{vFile};
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
                        ApplicationManager.getApplication().invokeLater(() -> installMarketplaceItem.2.invokeSuspend$lambda$1$lambda$0(this$0, vFile, $filePath));
                    } else {
                        VirtualFileManager.getInstance().asyncRefresh(null);
                    }
                }
                catch (Exception e) {
                    MarketplaceManager.notify$default(this$0, "Cannot open settings file: " + $filePath, false, 2, null);
                }
            }
        }), $completion);
    }

    public static /* synthetic */ Object installMarketplaceItem$default(MarketplaceManager marketplaceManager, MarketplaceItem marketplaceItem, InstallMarketplaceItemOptions installMarketplaceItemOptions, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            installMarketplaceItemOptions = null;
        }
        return marketplaceManager.installMarketplaceItem(marketplaceItem, installMarketplaceItemOptions, (Continuation<? super String>)continuation);
    }

    @Nullable
    public final Object removeItem(@NotNull MarketplaceItem item, @NotNull InstallMarketplaceItemOptions options, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(item, this, options, null){
            int label;
            final /* synthetic */ MarketplaceItem $item;
            final /* synthetic */ MarketplaceManager this$0;
            final /* synthetic */ InstallMarketplaceItemOptions $options;
            {
                this.$item = $item;
                this.this$0 = $receiver;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                block9: {
                    block10: {
                        void $result;
                        String string;
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                String string2 = this.$item.getType().toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                                string = string2;
                                if (!Intrinsics.areEqual((Object)string, (Object)"mcp")) break;
                                ComponentManager $this$service$iv = (ComponentManager)MarketplaceManager.access$getProject$p(this.this$0);
                                boolean $i$f$service = false;
                                Class<McpHub> serviceClass$iv = McpHub.class;
                                Object object3 = $this$service$iv.getService(serviceClass$iv);
                                if (object3 == null) {
                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                }
                                McpHub hub = (McpHub)object3;
                                this.label = 1;
                                Object object4 = hub.removeMarketplaceMcp(this.$item, this.$options.getTarget(), (Continuation<? super Unit>)((Continuation)this));
                                if (object4 == object2) {
                                    return object2;
                                }
                                break block9;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                break block9;
                            }
                        }
                        if (!Intrinsics.areEqual((Object)string, (Object)"mode")) break block10;
                        ComponentManager $this$service$iv = (ComponentManager)MarketplaceManager.access$getProject$p(this.this$0);
                        boolean $i$f$service = false;
                        Class<ComposerModeManager> serviceClass$iv = ComposerModeManager.class;
                        Object object5 = $this$service$iv.getService(serviceClass$iv);
                        if (object5 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        ComposerModeManager modeManager = (ComposerModeManager)object5;
                        this.label = 2;
                        Object object6 = modeManager.removeMarketplaceMode(this.$item, this.$options.getTarget(), this.$options.getParameters(), (Continuation<? super Unit>)((Continuation)this));
                        if (object6 == object2) {
                            return object2;
                        }
                        break block9;
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                object6 = $result;
                                break block9;
                            }
                        }
                    }
                    throw new IllegalArgumentException("Unsupported item type: " + this.$item.getType());
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void cleanup() {
        this.configLoader.clearCache();
    }

    private final void notify(String message, boolean isError) {
        NotificationGroupManager.getInstance().getNotificationGroup("Composer").createNotification(message, isError ? NotificationType.ERROR : NotificationType.INFORMATION).notify(this.project);
    }

    static /* synthetic */ void notify$default(MarketplaceManager marketplaceManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        marketplaceManager.notify(string, bl);
    }

    public static final /* synthetic */ RemoteConfigLoader access$getConfigLoader$p(MarketplaceManager $this) {
        return $this.configLoader;
    }

    public static final /* synthetic */ Logger access$getLogger$p(MarketplaceManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Map access$checkProjectInstallations(MarketplaceManager $this) {
        return $this.checkProjectInstallations();
    }

    public static final /* synthetic */ Map access$checkGlobalInstallations(MarketplaceManager $this) {
        return $this.checkGlobalInstallations();
    }

    public static final /* synthetic */ Project access$getProject$p(MarketplaceManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$notify(MarketplaceManager $this, String message, boolean isError) {
        $this.notify(message, isError);
    }
}

