/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.common;

import cn.gitlab.kilo.jetbrains.common.TranslationMapKt;
import cn.gitlab.kilo.jetbrains.composer.config.ComposerConfiguration;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import com.intellij.DynamicBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0006\u0010\f\u001a\u00020\u0001\u001a\u0006\u0010\t\u001a\u00020\u0001\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\r\u001a\u00020\u000e\u001a\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e\u001a\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e\u001a\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e\u001a\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e\u001a\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e\u001a\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e\u001a\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\u0005\u001a\u0004\b\u0007\u0010\u0003\"\u001b\u0010\t\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0005\u001a\u0004\b\n\u0010\u0003\"\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0005\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"ideLocale", "Ljava/util/Locale;", "getIdeLocale", "()Ljava/util/Locale;", "ideLocale$delegate", "Lkotlin/Lazy;", "chatLocale", "getChatLocale", "chatLocale$delegate", "commitLocale", "getCommitLocale", "commitLocale$delegate", "inlineEditLocale", "getLocaleStr", "", "getLocaleIndex", "", "resourceBundle", "Ljava/util/ResourceBundle;", "getResourceBundle", "()Ljava/util/ResourceBundle;", "resourceBundle$delegate", "getMessage", "key", "getMessageByChatLocale", "getPrompt", "getComposerPrompt", "getInlinePrompt", "getCommitPrompt", "getDirectTranslation", "msg", "coderider-kilo-jetbrains"})
public final class I18nKt {
    @NotNull
    private static final Lazy ideLocale$delegate = LazyKt.lazy(I18nKt::ideLocale_delegate$lambda$0);
    @NotNull
    private static final Lazy chatLocale$delegate = LazyKt.lazy(I18nKt::chatLocale_delegate$lambda$1);
    @NotNull
    private static final Lazy commitLocale$delegate = LazyKt.lazy(I18nKt::commitLocale_delegate$lambda$2);
    @NotNull
    private static final Lazy resourceBundle$delegate = LazyKt.lazy(I18nKt::resourceBundle_delegate$lambda$3);

    private static final Locale getIdeLocale() {
        Lazy lazy = ideLocale$delegate;
        return (Locale)lazy.getValue();
    }

    private static final Locale getChatLocale() {
        Lazy lazy = chatLocale$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Locale)object;
    }

    private static final Locale getCommitLocale() {
        Lazy lazy = commitLocale$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Locale)object;
    }

    @NotNull
    public static final Locale chatLocale() {
        return I18nKt.getChatLocale();
    }

    @NotNull
    public static final Locale inlineEditLocale() {
        return I18nKt.getIdeLocale();
    }

    @NotNull
    public static final Locale commitLocale() {
        return I18nKt.getCommitLocale();
    }

    @NotNull
    public static final Locale ideLocale() {
        return I18nKt.getIdeLocale();
    }

    @NotNull
    public static final String getLocaleStr() {
        String string = I18nKt.getIdeLocale().toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLanguageTag(...)");
        return string;
    }

    public static final int getLocaleIndex() {
        return StringsKt.contains$default((CharSequence)I18nKt.getLocaleStr(), (CharSequence)"zh", (boolean)false, (int)2, null) ? 0 : 1;
    }

    private static final ResourceBundle getResourceBundle() {
        Lazy lazy = resourceBundle$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ResourceBundle)object;
    }

    @NotNull
    public static final String getMessage(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            string = I18nKt.getResourceBundle().getString(key);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (MissingResourceException missingResourceException) {
            string = key;
        }
        return string;
    }

    @NotNull
    public static final String getMessageByChatLocale(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            string = ResourceBundle.getBundle("CockpitToolWindowFactory", I18nKt.getChatLocale()).getString(key);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (MissingResourceException missingResourceException) {
            string = key;
        }
        return string;
    }

    @NotNull
    public static final String getPrompt(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = ResourceBundle.getBundle("Prompt", I18nKt.getChatLocale()).getString(key);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public static final String getComposerPrompt(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Locale locale = Locale.forLanguageTag(ComposerConfiguration.Companion.getInstance().getState().getLanguage());
        String string = ResourceBundle.getBundle("Prompt", locale).getString(key);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public static final String getInlinePrompt(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = ResourceBundle.getBundle("Prompt", I18nKt.getIdeLocale()).getString(key);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public static final String getCommitPrompt(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = ResourceBundle.getBundle("Prompt", I18nKt.getCommitLocale()).getString(key);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public static final String getDirectTranslation(@NotNull String msg) {
        String string;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (Intrinsics.areEqual((Object)I18nKt.getIdeLocale(), (Object)Locale.SIMPLIFIED_CHINESE)) {
            string = TranslationMapKt.getEn2zhMap().get(msg);
            if (string == null) {
                string = msg;
            }
        } else {
            string = msg;
        }
        return string;
    }

    private static final Locale ideLocale_delegate$lambda$0() {
        Locale locale = DynamicBundle.getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
        return locale;
    }

    private static final Locale chatLocale_delegate$lambda$1() {
        return Locale.forLanguageTag(CockpitConfiguration.Companion.getInstance().getState().getDefaultChatLanguage());
    }

    private static final Locale commitLocale_delegate$lambda$2() {
        return Locale.forLanguageTag(CockpitConfiguration.Companion.getInstance().getState().getDefaultCommitLanguage());
    }

    private static final ResourceBundle resourceBundle_delegate$lambda$3() {
        return ResourceBundle.getBundle("CockpitToolWindowFactory", I18nKt.getIdeLocale());
    }
}

