/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.autocomplete;

import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J,\u0010\u0012\u001a\u00020\u00132\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcn/gitlab/kilo/jetbrains/autocomplete/CockpitCustomElementRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "font$delegate", "Lkotlin/Lazy;", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "coderider-kilo-jetbrains"})
public final class CockpitCustomElementRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final Editor editor;
    @NotNull
    private final String text;
    @NotNull
    private final Lazy font$delegate;

    public CockpitCustomElementRenderer(@NotNull Editor editor, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.editor = editor;
        this.text = text;
        this.font$delegate = LazyKt.lazy(() -> CockpitCustomElementRenderer.font_delegate$lambda$0(this));
    }

    private final Font getFont() {
        Lazy lazy = this.font$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Font)object;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return inlay.getEditor().getContentComponent().getFontMetrics(this.getFont()).stringWidth(this.text);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        g.setColor((Color)new JBColor(CockpitConfiguration.Companion.getInstance().getState().getCodeCompletionColor(), CockpitConfiguration.Companion.getInstance().getState().getCodeCompletionColor()));
        g.setFont(this.getFont());
        g.drawString(this.text, targetRegion.x, targetRegion.y + inlay.getEditor().getAscent());
    }

    private static final Font font_delegate$lambda$0(CockpitCustomElementRenderer this$0) {
        Font font = this$0.editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font editorFont = font;
        return UIUtil.getFontWithFallbackIfNeeded((Font)editorFont, (String)this$0.text).deriveFont(0, this$0.editor.getColorsScheme().getEditorFontSize());
    }
}

