/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.autocomplete;

import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteEditorListenerKt;
import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteService;
import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteServiceKt;
import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteTrigger;
import cn.gitlab.kilo.jetbrains.autocomplete.PendingCompletion;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.utils.UpdateFileSilentUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcn/gitlab/kilo/jetbrains/autocomplete/AutocompleteDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/fileEditor/FileEditorManager;Lcom/intellij/openapi/editor/Editor;)V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "recordHumanChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "coderider-kilo-jetbrains"})
public final class AutocompleteDocumentListener
implements DocumentListener {
    @NotNull
    private final FileEditorManager editorManager;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Logger logger;

    public AutocompleteDocumentListener(@NotNull FileEditorManager editorManager, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editorManager, (String)"editorManager");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editorManager = editorManager;
        this.editor = editor;
        this.logger = Logger.Companion.getInstance(AutocompleteDocumentListener.class);
    }

    private final void recordHumanChanged(DocumentEvent event) {
        block3: {
            block5: {
                block4: {
                    if (!CockpitConfiguration.Companion.getInstance().isLogin() || this.editor.getVirtualFile() == null) break block3;
                    if (UpdateFileSilentUtilsKt.isProgrammaticChange().booleanValue()) break block4;
                    Document document = event.getDocument();
                    DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
                    boolean bl = documentEx != null ? documentEx.isInBulkUpdate() : false;
                    if (!bl) break block5;
                }
                return;
            }
            AutocompleteEditorListenerKt.updateTotalBytesChanged(((Object)event.getNewFragment()).toString(), true);
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        block11: {
            block13: {
                String string;
                String pendingText;
                PendingCompletion pending;
                AutocompleteService autocompleteService;
                block15: {
                    block14: {
                        CharSequence newFragment;
                        block12: {
                            Regex bracketRegex;
                            int line;
                            block10: {
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                this.recordHumanChanged(event);
                                if (!Intrinsics.areEqual((Object)this.editor, (Object)this.editorManager.getSelectedTextEditor())) {
                                    return;
                                }
                                Project project = this.editor.getProject();
                                if (project == null) {
                                    return;
                                }
                                Project project2 = project;
                                AutocompleteService autocompleteService2 = AutocompleteServiceKt.getAutocompleteService(this.editor);
                                if (autocompleteService2 == null) {
                                    return;
                                }
                                autocompleteService = autocompleteService2;
                                if (autocompleteService.getLastChangeWasPartialAccept()) {
                                    return;
                                }
                                PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> AutocompleteDocumentListener.documentChanged$lambda$0(project2, this));
                                if (psiFile == null) {
                                    return;
                                }
                                PsiFile psiFile2 = psiFile;
                                pending = autocompleteService.getPendingCompletion();
                                line = this.editor.getDocument().getLineNumber(this.editor.getCaretModel().getOffset());
                                CharSequence charSequence = event.getNewFragment();
                                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                                newFragment = charSequence;
                                bracketRegex = new Regex("[(\\[{\"')\\]}]");
                                if (pending != null) break block10;
                                AutocompleteTrigger.launchAutoCompletion$default(AutocompleteTrigger.INSTANCE, this.editor, false, 2, null);
                                break block11;
                            }
                            if (pending.getCaretLineNumber() == line && !bracketRegex.containsMatchIn(newFragment)) break block12;
                            ApplicationManager.getApplication().runWriteAction(() -> AutocompleteDocumentListener.documentChanged$lambda$1(autocompleteService, this));
                            break block11;
                        }
                        if (!(newFragment.length() > 0)) break block13;
                        String string2 = pending.getText();
                        boolean bl = string2 != null ? StringsKt.startsWith$default((CharSequence)string2, (CharSequence)newFragment, (boolean)false, (int)2, null) : false;
                        if (!bl || Intrinsics.areEqual((Object)pending.getText(), (Object)((Object)newFragment).toString())) break block13;
                        pending.setOffset(pending.getOffset() + newFragment.length());
                        pendingText = pending.getText();
                        string = pending.getText();
                        if (string == null) break block14;
                        String string3 = string.substring(newFragment.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        string = string3;
                        if (string3 != null) break block15;
                    }
                    string = "";
                }
                pending.setText(string);
                autocompleteService.refreshPending();
                if (!pending.getAdopted()) {
                    String string4 = pendingText;
                    CoderiderTrackClient.INSTANCE.recordCodeCompletionAdopted(pending.getCompletionLines(), ModelsConfiguration.Companion.getInstance().getCurrentCodeModel(), pending.getLanguage(), string4 != null ? Integer.valueOf(string4.length()) : null);
                    pending.setAdopted(true);
                }
                break block11;
            }
            AutocompleteTrigger.launchAutoCompletion$default(AutocompleteTrigger.INSTANCE, this.editor, false, 2, null);
        }
    }

    private static final PsiFile documentChanged$lambda$0(Project $project, AutocompleteDocumentListener this$0) {
        return PsiDocumentManager.getInstance((Project)$project).getPsiFile(this$0.editor.getDocument());
    }

    private static final void documentChanged$lambda$1(AutocompleteService $autocompleteService, AutocompleteDocumentListener this$0) {
        $autocompleteService.cleanCompletions(this$0.editor);
    }
}

