/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.auth;

import cn.gitlab.kilo.jetbrains.auth.LoginPluginWindow;
import cn.gitlab.kilo.jetbrains.auth.LoginPluginWindowKt;
import cn.gitlab.kilo.jetbrains.auth.MissingJcefPanel;
import cn.gitlab.kilo.jetbrains.chat.ChatHandler;
import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.common.BackendServer;
import cn.gitlab.kilo.jetbrains.common.CommandRequest;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.DiscoverServers;
import cn.gitlab.kilo.jetbrains.common.ExtensionMessage;
import cn.gitlab.kilo.jetbrains.common.GetPublicConfig;
import cn.gitlab.kilo.jetbrains.common.GetResponse;
import cn.gitlab.kilo.jetbrains.common.GlobalStatus;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.LastCoderiderServerHost;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.LoginServerDiscovery;
import cn.gitlab.kilo.jetbrains.common.LoginViaPAT;
import cn.gitlab.kilo.jetbrains.common.MessageTip;
import cn.gitlab.kilo.jetbrains.common.PublicConfig;
import cn.gitlab.kilo.jetbrains.common.Route;
import cn.gitlab.kilo.jetbrains.common.SavedPat;
import cn.gitlab.kilo.jetbrains.composer.config.ComposerConfiguration;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.constants.ConstantsKt;
import cn.gitlab.kilo.jetbrains.factories.CustomLifeSpanHandler;
import cn.gitlab.kilo.jetbrains.factories.CustomerRequestHandler;
import cn.gitlab.kilo.jetbrains.factories.SchemeHandlerRegistrar;
import cn.gitlab.kilo.jetbrains.services.BrowserServiceKt;
import cn.gitlab.kilo.jetbrains.services.StorageService;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.toolWindow.CockpitToolWindowFactoryKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\b\u001a\u00020\t2'\u0010\n\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\u0002\b\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\tJ\b\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010\u001d\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/gitlab/kilo/jetbrains/auth/LoginPluginWindow;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "launchInScope", "", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)V", "reload", "webView", "Lcom/intellij/ui/jcef/JBCefBrowser;", "onThemeChanged", "createBrowser", "getContentPane", "Ljavax/swing/JComponent;", "registerAppSchemeHandler", "handleDiscoverServers", "url", "", "handleLoginViaPAT", "PAT", "inviteCode", "logUserIn", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nLoginPluginWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginPluginWindow.kt\ncn/gitlab/kilo/jetbrains/auth/LoginPluginWindow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n1#2:296\n*E\n"})
public final class LoginPluginWindow {
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private JBCefBrowser webView;

    public LoginPluginWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect();
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> LoginPluginWindow._init_$lambda$0(this, arg_0));
        try {
            this.webView = JBCefApp.isSupported() ? this.createBrowser(project) : null;
        }
        catch (Exception e) {
            LoginPluginWindowKt.getLogger().error(e);
        }
    }

    private final void launchInScope(Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super Unit>, Object> $block;
            {
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = this.$block.invoke((Object)$this$launch, (Object)((Object)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void reload() {
        block0: {
            JBCefBrowser jBCefBrowser = this.webView;
            if (jBCefBrowser == null || (jBCefBrowser = jBCefBrowser.getCefBrowser()) == null) break block0;
            jBCefBrowser.loadURL(ConstantsKt.getPluginWebViewUrl());
        }
    }

    private final void onThemeChanged() {
        block0: {
            JBCefBrowser jBCefBrowser = this.webView;
            if (jBCefBrowser == null) break block0;
            JBCefBrowser it = jBCefBrowser;
            boolean bl = false;
            ThemeUtilKt.updateTheme(it);
        }
    }

    private final JBCefBrowser createBrowser(Project project) {
        CockpitConfiguration.PluginState state = CockpitConfiguration.Companion.getInstance().getState();
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setEnableOpenDevToolsMenuItem(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        JBCefBrowser browser = jBCefBrowser;
        JBCefClient jBCefClient = browser.getJBCefClient();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefClient, (String)"getJBCefClient(...)");
        JBCefClient jbCefClient = jBCefClient;
        jbCefClient.addLifeSpanHandler((CefLifeSpanHandler)new CustomLifeSpanHandler(), browser.getCefBrowser());
        jbCefClient.addRequestHandler((CefRequestHandler)new CustomerRequestHandler(), browser.getCefBrowser());
        this.registerAppSchemeHandler();
        browser.loadURL(ConstantsKt.getPluginWebViewUrl());
        Disposer.register((Disposable)((Disposable)project), (Disposable)((Disposable)browser));
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)browser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        JBCefJSQuery myJSQueryOpenInBrowser = jBCefJSQuery;
        ChatHandler.INSTANCE.init(project);
        myJSQueryOpenInBrowser.addHandler(arg_0 -> LoginPluginWindow.createBrowser$lambda$7(arg_0 -> LoginPluginWindow.createBrowser$lambda$6(this, state, project, arg_0), arg_0));
        browser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(myJSQueryOpenInBrowser, this){
            final /* synthetic */ JBCefJSQuery $myJSQueryOpenInBrowser;
            final /* synthetic */ LoginPluginWindow this$0;
            {
                this.$myJSQueryOpenInBrowser = $myJSQueryOpenInBrowser;
                this.this$0 = $receiver;
            }

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                if (!isLoading) {
                    BrowserServiceKt.executeInitJavaScript(browser, this.$myJSQueryOpenInBrowser);
                    LoginPluginWindow.access$onThemeChanged(this.this$0);
                }
            }
        }, browser.getCefBrowser());
        return browser;
    }

    @NotNull
    public final JComponent getContentPane() {
        if (this.webView == null) {
            return new MissingJcefPanel();
        }
        JBCefBrowser jBCefBrowser = this.webView;
        Intrinsics.checkNotNull((Object)jBCefBrowser);
        JComponent jComponent = jBCefBrowser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final void registerAppSchemeHandler() {
        SchemeHandlerRegistrar.INSTANCE.ensureRegistered();
    }

    private final void handleDiscoverServers(String url) {
        block0: {
            CoderiderClientKt.setCoderiderClient(new CoderiderClient(url));
            CoderiderClientKt.getCoderiderClient().queryPublicConfig();
            CockpitConfiguration.PluginState state = CockpitConfiguration.Companion.getInstance().getState();
            String gitlabUrl = state.getGitlabHost();
            LoginServerDiscovery msg = new LoginServerDiscovery(null, new BackendServer(null, gitlabUrl, 1, null), 1, null);
            JBCefBrowser jBCefBrowser = this.webView;
            if (jBCefBrowser == null) break block0;
            JBCefBrowser it = jBCefBrowser;
            boolean bl = false;
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, it);
        }
    }

    private final void handleLoginViaPAT(String url, String PAT, String inviteCode) {
        String tempUrl = url;
        if (tempUrl.equals("https://jihulab.com")) {
            tempUrl = "https://coderider.jihulab.com";
        }
        CoderiderClientKt.setCoderiderClient(new CoderiderClient(tempUrl));
        try {
            CockpitConfiguration.Companion.getInstance().getState().setGitlabPAT(PAT);
            CoderiderClient.refreshMetaData$default(CoderiderClientKt.getCoderiderClient(), inviteCode, 0, 0L, 6, null);
        }
        catch (CustomException e) {
            Object message = "\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbf\u95ee\u4ee4\u724c\u662f\u5426\u6709\u6548: " + e.getMessage();
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"License Invalid", (boolean)false, (int)2, null) : false;
            if (bl) {
                message = I18nKt.getMessage("enterprise.coderider.license.invalid");
            }
            e.printStackTrace();
            MessageTip msg = new MessageTip(null, "error", (String)message, 1, null);
            JBCefBrowser jBCefBrowser = this.webView;
            if (jBCefBrowser != null) {
                JBCefBrowser it = jBCefBrowser;
                boolean bl2 = false;
                ThemeUtilKt.sendToWebview((ExtensionMessage)msg, it);
            }
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            MessageTip msg = new MessageTip(null, "error", "\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbf\u95ee\u4ee4\u724c\u662f\u5426\u6709\u6548: " + e.getMessage(), 1, null);
            JBCefBrowser jBCefBrowser = this.webView;
            if (jBCefBrowser != null) {
                JBCefBrowser it = jBCefBrowser;
                boolean bl = false;
                ThemeUtilKt.sendToWebview((ExtensionMessage)msg, it);
            }
            return;
        }
        this.logUserIn();
        Logger.info$default(LoginPluginWindowKt.getLogger(), "command: handleLoginViaPAT, User Login Success!,url:" + url, null, 2, null);
    }

    static /* synthetic */ void handleLoginViaPAT$default(LoginPluginWindow loginPluginWindow, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        loginPluginWindow.handleLoginViaPAT(string, string2, string3);
    }

    private final void logUserIn() {
        UtilKt.stream((Object[])CockpitToolWindowFactoryKt.getProjects()).forEach(arg_0 -> LoginPluginWindow.logUserIn$lambda$11(logUserIn.1.INSTANCE, arg_0));
        TrackService.INSTANCE.activate();
    }

    private static final void _init_$lambda$0(LoginPluginWindow this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onThemeChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final JBCefJSQuery.Response createBrowser$lambda$6(LoginPluginWindow this$0, CockpitConfiguration.PluginState $state, Project $project, String msg) {
        JsonObject jsonObject2 = JsonParser.parseString((String)msg).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
        JsonObject msgJsonObject = jsonObject2;
        String command = msgJsonObject.get("command").getAsString();
        Object object = msgJsonObject.get("requestId");
        if (object == null || (object = object.getAsString()) == null) {
            object = "";
        }
        Object object2 = object;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String os = string2;
        Logger.debug$default(LoginPluginWindowKt.getLogger(), "command: " + command + ", requestId: " + (String)object2 + ", msg: " + msg, null, 2, null);
        try {
            String string3 = command;
            if (string3 == null) return null;
            int n = -1;
            switch (string3.hashCode()) {
                case -925132997: {
                    if (string3.equals("routed")) {
                        n = 1;
                    }
                    break;
                }
                case 1098253751: {
                    if (string3.equals("removeItem")) {
                        n = 2;
                    }
                    break;
                }
                case 1390064254: {
                    if (string3.equals("loginViaPAT")) {
                        n = 3;
                    }
                    break;
                }
                case 1698005377: {
                    if (string3.equals("getPublicConfig")) {
                        n = 4;
                    }
                    break;
                }
                case -70896864: {
                    if (string3.equals("clearLastPAT")) {
                        n = 5;
                    }
                    break;
                }
                case 1657191102: {
                    if (string3.equals("loginDiscoverServers")) {
                        n = 6;
                    }
                    break;
                }
                case 591692925: {
                    if (string3.equals("getConfigCodeRiderHost")) {
                        n = 7;
                    }
                    break;
                }
                case 989777399: {
                    if (string3.equals("getLastPAT")) {
                        n = 8;
                    }
                    break;
                }
                case -75439223: {
                    if (string3.equals("getItem")) {
                        n = 2;
                    }
                    break;
                }
                case 1242932856: {
                    if (string3.equals("mounted")) {
                        n = 9;
                    }
                    break;
                }
                case 1984670357: {
                    if (string3.equals("setItem")) {
                        n = 2;
                    }
                    break;
                }
            }
            switch (n) {
                case 9: {
                    JBCefBrowser jBCefBrowser = this$0.webView;
                    Intrinsics.checkNotNull((Object)jBCefBrowser);
                    ThemeUtilKt.updateTheme(jBCefBrowser);
                    if (StringsKt.contains$default((CharSequence)os, (CharSequence)"mac", (boolean)false, (int)2, null)) {
                        os = "darwin";
                    }
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"os", (Object)os)};
                    GlobalStatus statusMessage = new GlobalStatus(null, MapsKt.mutableMapOf((Pair[])pairArray), 1, null);
                    ExtensionMessage extensionMessage = statusMessage;
                    JBCefBrowser jBCefBrowser2 = this$0.webView;
                    Intrinsics.checkNotNull((Object)jBCefBrowser2);
                    ThemeUtilKt.sendToWebview(extensionMessage, jBCefBrowser2);
                    Route message = new Route("route", "/login");
                    ExtensionMessage extensionMessage2 = message;
                    JBCefBrowser jBCefBrowser3 = this$0.webView;
                    Intrinsics.checkNotNull((Object)jBCefBrowser3);
                    ThemeUtilKt.sendToWebview(extensionMessage2, jBCefBrowser3);
                    return null;
                }
                case 7: {
                    GetResponse<LastCoderiderServerHost> coderiderServerConfig = new GetResponse<LastCoderiderServerHost>("getConfigCodeRiderHostResponse", new LastCoderiderServerHost(StringsKt.removeSuffix((String)$state.getCoderiderServerHost(), (CharSequence)"/")), (String)object2);
                    ExtensionMessage extensionMessage = coderiderServerConfig;
                    JBCefBrowser jBCefBrowser = this$0.webView;
                    Intrinsics.checkNotNull((Object)jBCefBrowser);
                    ThemeUtilKt.sendToWebview(extensionMessage, jBCefBrowser);
                    return null;
                }
                case 6: {
                    String string4 = msg;
                    if (string4 == null) return null;
                    String it = string4;
                    boolean bl = false;
                    DiscoverServers discoverServers = (DiscoverServers)new Gson().fromJson(it, DiscoverServers.class);
                    DiscoverServers discoverServers2 = discoverServers;
                    if (discoverServers2 == null) return null;
                    this$0.handleDiscoverServers(discoverServers2.getUrl());
                    return null;
                }
                case 3: {
                    String string5 = msg;
                    if (string5 == null) return null;
                    String it = string5;
                    boolean bl = false;
                    LoginViaPAT loginViaPAT = (LoginViaPAT)new Gson().fromJson(it, LoginViaPAT.class);
                    LoginViaPAT login = loginViaPAT;
                    if (login == null) return null;
                    this$0.handleLoginViaPAT(StringsKt.removeSuffix((String)login.getCoderiderHost(), (CharSequence)"/"), login.getToken(), login.getInviteCode());
                    CockpitConfiguration.Companion.getInstance().getState().setSavePAT(login.getSavePAT());
                    ComposerConfiguration.Companion.getInstance().getState().setDismissedNotificationIds(null);
                    if (!login.getSavePAT()) return null;
                    CockpitConfiguration.Companion.getInstance().getState().setGitlabPAT(login.getToken());
                    return null;
                }
                case 4: {
                    ThemeUtilKt.webLaunchInScope((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(msg, command, this$0, null){
                        int label;
                        final /* synthetic */ String $msg;
                        final /* synthetic */ String $command;
                        final /* synthetic */ LoginPluginWindow this$0;
                        {
                            this.$msg = $msg;
                            this.$command = $command;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    Type type2 = new TypeToken<CommandRequest<GetPublicConfig>>(){}.getType();
                                    Object object2 = new Gson().fromJson(this.$msg, type2);
                                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
                                    CommandRequest commandRequest = (CommandRequest)object2;
                                    CockpitConfiguration.Companion.getInstance().getState().setCoderiderServerHost(((GetPublicConfig)commandRequest.getPayload()).getInstanceUrl());
                                    CoderiderClientKt.setCoderiderClient(new CoderiderClient(StringsKt.removeSuffix((String)((GetPublicConfig)commandRequest.getPayload()).getInstanceUrl(), (CharSequence)"/")));
                                    try {
                                        CoderiderClientKt.getCoderiderClient().queryPublicConfig();
                                        GetResponse<PublicConfig> response = new GetResponse<PublicConfig>(this.$command + "Response", new PublicConfig(CockpitConfiguration.Companion.getInstance().getState().getGitlabHost(), "", CockpitConfiguration.Companion.getInstance().getState().getSecurityStatement(), CockpitConfiguration.Companion.getInstance().getState().getGitlabPatUrl()), commandRequest.getRequestId());
                                        JBCefBrowser jBCefBrowser = LoginPluginWindow.access$getWebView$p(this.this$0);
                                        if (jBCefBrowser == null) return Unit.INSTANCE;
                                        JBCefBrowser it = jBCefBrowser;
                                        boolean bl = false;
                                        ThemeUtilKt.sendToWebview((ExtensionMessage)response, it);
                                        return Unit.INSTANCE;
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                        MessageTip msg = new MessageTip(null, "error", "\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbf\u95ee\u7f51\u5740\u662f\u5426\u6709\u6548: " + e.getMessage(), 1, null);
                                        JBCefBrowser jBCefBrowser = LoginPluginWindow.access$getWebView$p(this.this$0);
                                        if (jBCefBrowser == null) return Unit.INSTANCE;
                                        JBCefBrowser it = jBCefBrowser;
                                        boolean bl = false;
                                        ThemeUtilKt.sendToWebview((ExtensionMessage)msg, it);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    return null;
                }
                case 8: {
                    GetResponse<SavedPat> response = new GetResponse<SavedPat>(command + "Response", new SavedPat($state.getGitlabPAT()), (String)object2);
                    JBCefBrowser jBCefBrowser = this$0.webView;
                    if (jBCefBrowser == null) return null;
                    JBCefBrowser it = jBCefBrowser;
                    boolean bl = false;
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, it);
                    return null;
                }
                case 5: {
                    $state.setGitlabPAT(null);
                    return null;
                }
                case 2: {
                    String string6 = msg;
                    if (string6 == null) return null;
                    String it = string6;
                    boolean bl = false;
                    JBCefBrowser jBCefBrowser = this$0.webView;
                    Intrinsics.checkNotNull((Object)jBCefBrowser);
                    StorageService.INSTANCE.handleWebviewMessage(it, jBCefBrowser, $project);
                    return null;
                }
                default: {
                    return null;
                }
                case 1: {
                    return null;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private static final JBCefJSQuery.Response createBrowser$lambda$7(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final void logUserIn$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$onThemeChanged(LoginPluginWindow $this) {
        $this.onThemeChanged();
    }

    public static final /* synthetic */ JBCefBrowser access$getWebView$p(LoginPluginWindow $this) {
        return $this.webView;
    }
}

