/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.consumer.LogSplitMode;
import com.sensorsdata.analytics.javasdk.consumer.LoggingFileWriter;
import com.sensorsdata.analytics.javasdk.consumer.LoggingFileWriterFactory;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InnerLoggingConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(InnerLoggingConsumer.class);
    private static final int BUFFER_LIMITATION = 0x40000000;
    private final ObjectMapper jsonMapper;
    private final String filenamePrefix;
    private final StringBuilder messageBuffer;
    private final int bufferSize;
    private final SimpleDateFormat simpleDateFormat;
    private final LoggingFileWriterFactory fileWriterFactory;
    private LoggingFileWriter fileWriter;

    InnerLoggingConsumer(LoggingFileWriterFactory fileWriterFactory, String filenamePrefix, int bufferSize, LogSplitMode splitMode) {
        this.fileWriterFactory = fileWriterFactory;
        this.filenamePrefix = filenamePrefix;
        this.jsonMapper = SensorsAnalyticsUtil.getJsonObjectMapper();
        this.messageBuffer = new StringBuilder(bufferSize);
        this.bufferSize = bufferSize;
        this.simpleDateFormat = splitMode == LogSplitMode.HOUR ? new SimpleDateFormat("yyyy-MM-dd-HH") : new SimpleDateFormat("yyyy-MM-dd");
        log.info("Initialize LoggingConsumer with params:[filenamePrefix:{},bufferSize:{},splitMode:{}].", new Object[]{filenamePrefix, bufferSize, splitMode});
    }

    @Override
    public synchronized void send(Map<String, Object> message) {
        if (this.messageBuffer.length() < 0x40000000) {
            try {
                this.messageBuffer.append(this.jsonMapper.writeValueAsString(message));
                this.messageBuffer.append("\n");
            }
            catch (JsonProcessingException e) {
                log.error("Failed to process json.", (Throwable)e);
                throw new RuntimeException("fail to process json", e);
            }
        } else {
            log.error("Logging cache exceeded the allowed limitation,current cache size is {}.", (Object)this.messageBuffer.length());
            throw new RuntimeException("logging buffer exceeded the allowed limitation.");
        }
        log.info("Successfully save data to cache,The cache current size is {}.", (Object)this.messageBuffer.length());
        if (this.messageBuffer.length() >= this.bufferSize) {
            log.info("Flush triggered because logging cache size reached the threshold,cache size:{},bulkSize:{}.", (Object)this.messageBuffer.length(), (Object)this.bufferSize);
            this.flush();
        }
    }

    private String constructFileName(Date now) {
        return this.filenamePrefix + "." + this.simpleDateFormat.format(now);
    }

    @Override
    public synchronized void flush() {
        if (this.messageBuffer.length() == 0) {
            log.info("The cache is empty when flush.");
            return;
        }
        String filename = this.constructFileName(new Date());
        if (this.fileWriter != null && !this.fileWriter.isValid(filename)) {
            this.fileWriterFactory.closeFileWriter(this.fileWriter);
            log.info("The new file name [{}] is different from current file name,so update file writer.", (Object)filename);
            this.fileWriter = null;
        }
        if (this.fileWriter == null) {
            try {
                this.fileWriter = this.fileWriterFactory.getFileWriter(this.filenamePrefix, filename);
            }
            catch (FileNotFoundException e) {
                log.error("Failed to create file Writer.", (Throwable)e);
                throw new RuntimeException(e);
            }
            log.info("Initialize LoggingConsumer file writer,fileName:{}.", (Object)filename);
        }
        log.debug("Will be write data from cache to file.[{}]", (Object)this.messageBuffer);
        if (this.fileWriter.write(this.messageBuffer)) {
            this.messageBuffer.setLength(0);
            log.info("Successfully write data from cache to file.");
        }
    }

    @Override
    public synchronized void close() {
        this.flush();
        if (this.fileWriter != null) {
            this.fileWriterFactory.closeFileWriter(this.fileWriter);
            this.fileWriter = null;
        }
        log.info("Call close method.");
    }
}

