/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensorsdata.analytics.javasdk.bean.FailedData;
import com.sensorsdata.analytics.javasdk.consumer.Callback;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.consumer.HttpConsumer;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastBatchConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(FastBatchConsumer.class);
    private static final int MAX_CACHE_SIZE = 10000;
    private static final int MIN_CACHE_SIZE = 1000;
    private static final int MIN_BULK_SIZE = 1;
    private final LinkedBlockingQueue<Map<String, Object>> buffer;
    private final HttpConsumer httpConsumer;
    private final ObjectMapper jsonMapper;
    private final Callback callback;
    private final int bulkSize;
    private final ScheduledExecutorService executorService;

    public FastBatchConsumer(@NonNull String serverUrl, @NonNull Callback callback) {
        this(serverUrl, false, callback);
        if (serverUrl == null) {
            throw new NullPointerException("serverUrl is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
    }

    public FastBatchConsumer(@NonNull String serverUrl, int flushSec, boolean timing, @NonNull Callback callback) {
        this(serverUrl, timing, 50, 6000, flushSec, 3, callback);
        if (serverUrl == null) {
            throw new NullPointerException("serverUrl is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
    }

    public FastBatchConsumer(@NonNull String serverUrl, boolean timing, @NonNull Callback callback) {
        this(serverUrl, timing, 50, callback);
        if (serverUrl == null) {
            throw new NullPointerException("serverUrl is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
    }

    public FastBatchConsumer(@NonNull String serverUrl, boolean timing, int bulkSize, @NonNull Callback callback) {
        this(serverUrl, timing, bulkSize, 6000, callback);
        if (serverUrl == null) {
            throw new NullPointerException("serverUrl is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
    }

    public FastBatchConsumer(@NonNull String serverUrl, boolean timing, int bulkSize, int maxCacheSize, @NonNull Callback callback) {
        this(serverUrl, timing, bulkSize, maxCacheSize, 1, 3, callback);
        if (serverUrl == null) {
            throw new NullPointerException("serverUrl is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
    }

    public FastBatchConsumer(@NonNull String serverUrl, final boolean timing, final int bulkSize, int maxCacheSize, int flushSec, int timeoutSec, @NonNull Callback callback) {
        if (serverUrl == null) {
            throw new NullPointerException("serverUrl is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.buffer = new LinkedBlockingQueue(Math.min(Math.max(1000, maxCacheSize), 10000));
        this.httpConsumer = new HttpConsumer(serverUrl, Math.max(timeoutSec, 1));
        this.jsonMapper = SensorsAnalyticsUtil.getJsonObjectMapper();
        this.callback = callback;
        this.bulkSize = Math.min(1000, Math.max(bulkSize, 1));
        this.executorService = new ScheduledThreadPoolExecutor(1);
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (timing) {
                    FastBatchConsumer.this.flush();
                } else if (FastBatchConsumer.this.buffer.size() >= bulkSize) {
                    FastBatchConsumer.this.flush();
                }
            }
        }, 1L, Math.max(flushSec, 1), TimeUnit.SECONDS);
        log.info("Initialize FastBatchConsumer with params:[timing:{};bulkSize:{};maxCacheSize:{};flushSec:{};timeoutSec:{}].", new Object[]{timing, bulkSize, maxCacheSize, flushSec, timeoutSec});
    }

    @Override
    public void send(Map<String, Object> message) {
        if (!this.buffer.offer(message)) {
            ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(1);
            res.add(message);
            this.callback.onFailed(new FailedData("can't offer to buffer.", res));
            log.error("Failed to load data into the cache.The cache current size is {}.", (Object)this.buffer.size());
        }
        log.info("Successfully save data to cache.The cache current size is {}.", (Object)this.buffer.size());
    }

    @Override
    public void flush() {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        this.buffer.drainTo(results);
        if (results.isEmpty()) {
            log.info("The Data of cache is empty when flush.");
            return;
        }
        log.info("Successfully get [{}] messages from the cache.", (Object)results.size());
        while (!results.isEmpty()) {
            String sendingData;
            List sendList = results.subList(0, Math.min(this.bulkSize, results.size()));
            try {
                sendingData = this.jsonMapper.writeValueAsString(sendList);
            }
            catch (JsonProcessingException e) {
                this.callback.onFailed(new FailedData(String.format("can't process json,message:%s.", e.getMessage()), SensorsAnalyticsUtil.deepCopy(results)));
                sendList.clear();
                log.error("Failed to process json.", (Throwable)e);
                continue;
            }
            log.debug("Data will be sent.{}", (Object)sendingData);
            try {
                this.httpConsumer.consume(sendingData);
            }
            catch (Exception e) {
                log.error("Failed to send data:{}.", (Object)sendingData, (Object)e);
                this.callback.onFailed(new FailedData(String.format("failed to send data,message:%s.", e.getMessage()), SensorsAnalyticsUtil.deepCopy(results)));
            }
            sendList.clear();
        }
        log.info("Finish flush.");
    }

    @Override
    public void close() {
        log.info("Call close method.");
        this.httpConsumer.close();
        this.executorService.shutdown();
    }

    public boolean resendFailedData(@NonNull FailedData failedData) throws InvalidArgumentException, JsonProcessingException {
        if (failedData == null) {
            throw new NullPointerException("failedData is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertFailedData(failedData);
        String sendData = this.jsonMapper.writeValueAsString(failedData.getFailedData());
        log.debug("Will be resent data.{}", (Object)sendData);
        try {
            this.httpConsumer.consume(sendData);
        }
        catch (Exception e) {
            log.error("failed to send data.data:{}.", (Object)sendData, (Object)e);
            return false;
        }
        log.info("Successfully resend failed data.");
        return true;
    }
}

