/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.bean.IDMEventRecord;
import com.sensorsdata.analytics.javasdk.bean.IDMUserRecord;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

class SensorsData {
    private Integer trackId = new Random().nextInt();
    private String distinctId;
    private String originalId;
    private Map<String, String> identities;
    private String type;
    private String event;
    private Map<String, String> lib;
    private Date time;
    private Map<String, Object> properties;
    private String project;
    private String token;
    private String itemType;
    private String itemId;

    protected SensorsData(IDMUserRecord userRecord, String actionType) {
        this(userRecord.getDistinctId(), actionType, userRecord.getIdentityMap(), userRecord.getPropertyMap());
    }

    protected SensorsData(IDMEventRecord eventRecord) {
        this(eventRecord.getDistinctId(), eventRecord.getIdentityMap(), eventRecord.getEventName(), eventRecord.getPropertyMap());
    }

    protected SensorsData(String distinctId, String type, Map<String, String> identities, Map<String, Object> properties) {
        this(distinctId, null, identities, type, null, properties, null, null);
    }

    protected SensorsData(String distinctId, Map<String, String> identities, String event, Map<String, Object> properties) {
        this(distinctId, null, identities, "track", event, properties, null, null);
    }

    private SensorsData(String distinctId, String originalId, Map<String, String> identities, String type, String event, Map<String, Object> properties, String itemType, String itemId) {
        this.distinctId = distinctId;
        this.originalId = originalId;
        this.identities = identities;
        this.type = type;
        this.event = event;
        this.lib = SensorsAnalyticsUtil.generateLibInfo();
        this.time = new Date();
        this.properties = properties;
        this.itemType = itemType;
        this.itemId = itemId;
    }

    protected static Map<String, Object> generateData(SensorsData sensorsData) {
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        if (sensorsData.getTrackId() != null) {
            eventMap.put("_track_id", sensorsData.getTrackId());
        }
        if (sensorsData.getDistinctId() != null) {
            eventMap.put("distinct_id", sensorsData.getDistinctId());
        }
        if (sensorsData.getOriginalId() != null) {
            eventMap.put("original_id", sensorsData.getOriginalId());
        }
        if (sensorsData.getIdentities() != null) {
            eventMap.put("identities", sensorsData.getIdentities());
        }
        if (sensorsData.getType() != null) {
            eventMap.put("type", sensorsData.getType());
        }
        if (sensorsData.getEvent() != null) {
            eventMap.put("event", sensorsData.getEvent());
        }
        if (sensorsData.getLib() != null) {
            eventMap.put("lib", sensorsData.getLib());
        }
        eventMap.put("time", sensorsData.getTime().getTime());
        if (sensorsData.getProject() != null) {
            eventMap.put("project", sensorsData.getProject());
        }
        if (sensorsData.getToken() != null) {
            eventMap.put("token", sensorsData.getToken());
        }
        if (sensorsData.getItemId() != null) {
            eventMap.put("item_id", sensorsData.getItemId());
        }
        if (sensorsData.getItemType() != null) {
            eventMap.put("item_type", sensorsData.getItemType());
        }
        if (sensorsData.getProperties() != null) {
            eventMap.put("properties", sensorsData.getProperties());
        }
        return eventMap;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public Map<String, String> getIdentities() {
        return this.identities;
    }

    public String getType() {
        return this.type;
    }

    public String getEvent() {
        return this.event;
    }

    public Map<String, String> getLib() {
        return this.lib;
    }

    public Date getTime() {
        return this.time;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getProject() {
        return this.project;
    }

    public String getToken() {
        return this.token;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setTrackId(Integer trackId) {
        this.trackId = trackId;
    }

    public void setDistinctId(String distinctId) {
        this.distinctId = distinctId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public void setIdentities(Map<String, String> identities) {
        this.identities = identities;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setLib(Map<String, String> lib) {
        this.lib = lib;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }
}

