/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.SensorsAnalyticsWorker;
import com.sensorsdata.analytics.javasdk.SensorsData;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import com.sensorsdata.analytics.javasdk.bean.IDMEventRecord;
import com.sensorsdata.analytics.javasdk.bean.IDMUserRecord;
import com.sensorsdata.analytics.javasdk.bean.ItemRecord;
import com.sensorsdata.analytics.javasdk.bean.SensorsAnalyticsIdentity;
import com.sensorsdata.analytics.javasdk.bean.SuperPropertiesRecord;
import com.sensorsdata.analytics.javasdk.bean.UserRecord;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class SensorsAnalytics
implements ISensorsAnalytics {
    private final SensorsAnalyticsWorker worker;
    private static final String DISTINCT_ID = "distinct_id";
    private static final String EVENT_NAME = "event name";
    private static final String ORIGINAL_DISTINCT_ID = "Original Distinct Id";
    private static final String ITEM_TYPE = "Item Type";
    private static final String ITEM_ID = "Item Id";

    public SensorsAnalytics(Consumer consumer) {
        this.worker = new SensorsAnalyticsWorker(consumer);
    }

    @Override
    public void setEnableTimeFree(@NonNull boolean enableTimeFree) {
        this.worker.setEnableTimeFree(enableTimeFree);
    }

    @Override
    public void registerSuperProperties(@NonNull SuperPropertiesRecord propertiesRecord) {
        if (propertiesRecord == null) {
            throw new NullPointerException("propertiesRecord is marked non-null but is null");
        }
        this.worker.setSuperProperties(propertiesRecord.getPropertyMap());
    }

    @Override
    public void registerSuperProperties(@NonNull Map<String, Object> superPropertiesMap) {
        if (superPropertiesMap == null) {
            throw new NullPointerException("superPropertiesMap is marked non-null but is null");
        }
        this.worker.setSuperProperties(superPropertiesMap);
    }

    @Override
    public void clearSuperProperties() {
        this.worker.clearSuperProperties();
    }

    @Override
    public void track(@NonNull EventRecord eventRecord) throws InvalidArgumentException {
        if (eventRecord == null) {
            throw new NullPointerException("eventRecord is marked non-null but is null");
        }
        this.addEvent(eventRecord.getDistinctId(), eventRecord.getIsLoginId(), null, "track", eventRecord.getEventName(), eventRecord.getPropertyMap());
    }

    @Override
    public void profileSet(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_set");
    }

    @Override
    public void profileSetOnce(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_set_once");
    }

    @Override
    public void profileAppend(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_append");
    }

    @Override
    public void profileIncrement(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_increment");
    }

    @Override
    public void profileUnset(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_unset");
    }

    @Override
    public void profileDelete(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_delete");
    }

    @Override
    public void itemSet(@NonNull ItemRecord itemRecord) throws InvalidArgumentException {
        if (itemRecord == null) {
            throw new NullPointerException("itemRecord is marked non-null but is null");
        }
        this.addItem(itemRecord.getItemType(), itemRecord.getItemId(), "item_set", itemRecord.getPropertyMap());
    }

    @Override
    public void itemDelete(@NonNull ItemRecord itemRecord) throws InvalidArgumentException {
        if (itemRecord == null) {
            throw new NullPointerException("itemRecord is marked non-null but is null");
        }
        this.addItem(itemRecord.getItemType(), itemRecord.getItemId(), "item_delete", itemRecord.getPropertyMap());
    }

    @Override
    public void track(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String eventName) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "track", eventName, null);
    }

    @Override
    public void track(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "track", eventName, properties);
    }

    @Override
    public void trackSignUp(@NonNull String loginId, @NonNull String anonymousId) throws InvalidArgumentException {
        if (loginId == null) {
            throw new NullPointerException("loginId is marked non-null but is null");
        }
        if (anonymousId == null) {
            throw new NullPointerException("anonymousId is marked non-null but is null");
        }
        this.addEvent(loginId, false, anonymousId, "track_signup", "$SignUp", null);
    }

    @Override
    public void trackSignUp(@NonNull String loginId, @NonNull String anonymousId, Map<String, Object> properties) throws InvalidArgumentException {
        if (loginId == null) {
            throw new NullPointerException("loginId is marked non-null but is null");
        }
        if (anonymousId == null) {
            throw new NullPointerException("anonymousId is marked non-null but is null");
        }
        this.addEvent(loginId, false, anonymousId, "track_signup", "$SignUp", properties);
    }

    @Override
    public void profileSet(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "profile_set", null, properties);
    }

    @Override
    public void profileSet(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property, @NonNull Object value) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_set", null, properties);
    }

    @Override
    public void profileSetOnce(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "profile_set_once", null, properties);
    }

    @Override
    public void profileSetOnce(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property, @NonNull Object value) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_set_once", null, properties);
    }

    @Override
    public void profileIncrement(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "profile_increment", null, properties);
    }

    @Override
    public void profileIncrement(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property, @NonNull long value) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_increment", null, properties);
    }

    @Override
    public void profileAppend(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "profile_append", null, properties);
    }

    @Override
    public void profileAppend(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property, @NonNull String value) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, values);
        this.addEvent(distinctId, isLoginId, null, "profile_append", null, properties);
    }

    @Override
    public void profileUnset(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, true);
        this.addEvent(distinctId, isLoginId, null, "profile_unset", null, properties);
    }

    @Override
    public void profileUnset(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            boolean value;
            if ("$project".equals(property.getKey()) || property.getValue() instanceof Boolean && (value = ((Boolean)property.getValue()).booleanValue())) continue;
            throw new InvalidArgumentException("The property value of " + property.getKey() + " should be true.");
        }
        this.addEvent(distinctId, isLoginId, null, "profile_unset", null, properties);
    }

    @Override
    public void profileDelete(@NonNull String distinctId, @NonNull boolean isLoginId) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "profile_delete", null, null);
    }

    @Override
    public void itemSet(@NonNull String itemType, @NonNull String itemId, Map<String, Object> properties) throws InvalidArgumentException {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (itemId == null) {
            throw new NullPointerException("itemId is marked non-null but is null");
        }
        this.addItem(itemType, itemId, "item_set", properties);
    }

    @Override
    public void itemDelete(@NonNull String itemType, @NonNull String itemId, Map<String, Object> properties) throws InvalidArgumentException {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (itemId == null) {
            throw new NullPointerException("itemId is marked non-null but is null");
        }
        this.addItem(itemType, itemId, "item_delete", properties);
    }

    @Override
    public void bind(SensorsAnalyticsIdentity ... identities) throws InvalidArgumentException {
        if (identities == null) {
            throw new NullPointerException("identities is marked non-null but is null");
        }
        HashMap<String, String> identityMap = new HashMap<String, String>();
        for (SensorsAnalyticsIdentity identity : identities) {
            identityMap.putAll(identity.getIdentityMap());
        }
        if (identityMap.size() < 2) {
            throw new InvalidArgumentException("The identities is invalid\uff0cyou should have at least two identities.");
        }
        this.assertIdentityMap("track_id_bind", identityMap);
        this.worker.doAddEventIdentity(identityMap, "track_id_bind", "$BindID", null);
    }

    @Override
    public void unbind(@NonNull SensorsAnalyticsIdentity analyticsIdentity) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addEventIdentity(analyticsIdentity, "track_id_unbind", "$UnbindID", null);
    }

    @Override
    public void trackById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        IDMEventRecord eventRecord = IDMEventRecord.starter().identityMap(analyticsIdentity.getIdentityMap()).setEventName(eventName).addProperties(properties).build();
        this.worker.doAddData(new SensorsData(eventRecord));
    }

    @Override
    public void profileSetById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addEventIdentity(analyticsIdentity, "profile_set", null, properties);
    }

    @Override
    public void profileSetById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String property, @NonNull Object value) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEventIdentity(analyticsIdentity, "profile_set", null, properties);
    }

    @Override
    public void profileSetOnceById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addEventIdentity(analyticsIdentity, "profile_set_once", null, properties);
    }

    @Override
    public void profileSetOnceById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String property, @NonNull Object value) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEventIdentity(analyticsIdentity, "profile_set_once", null, properties);
    }

    @Override
    public void profileIncrementById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addEventIdentity(analyticsIdentity, "profile_increment", null, properties);
    }

    @Override
    public void profileIncrementById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, String property, long value) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEventIdentity(analyticsIdentity, "profile_increment", null, properties);
    }

    @Override
    public void profileAppendById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addEventIdentity(analyticsIdentity, "profile_append", null, properties);
    }

    @Override
    public void profileAppendById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String property, @NonNull String value) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, values);
        this.addEventIdentity(analyticsIdentity, "profile_append", null, properties);
    }

    @Override
    public void profileUnsetById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            boolean value;
            if ("$project".equals(property.getKey()) || property.getValue() instanceof Boolean && (value = ((Boolean)property.getValue()).booleanValue())) continue;
            throw new InvalidArgumentException("The property value of [" + property.getKey() + "] should be true.");
        }
        this.addEventIdentity(analyticsIdentity, "profile_unset", null, properties);
    }

    @Override
    public void profileUnsetById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String property) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, true);
        this.addEventIdentity(analyticsIdentity, "profile_unset", null, properties);
    }

    @Override
    public void profileDeleteById(@NonNull SensorsAnalyticsIdentity analyticsIdentity) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addEventIdentity(analyticsIdentity, "profile_delete", null, null);
    }

    @Override
    public void trackById(@NonNull IDMEventRecord idmEventRecord) throws InvalidArgumentException {
        if (idmEventRecord == null) {
            throw new NullPointerException("idmEventRecord is marked non-null but is null");
        }
        this.worker.doAddData(new SensorsData(idmEventRecord));
    }

    @Override
    public void profileSetById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_set", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_set"));
    }

    @Override
    public void profileSetOnceById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_set_once", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_set_once"));
    }

    @Override
    public void profileIncrementById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_increment", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_increment"));
    }

    @Override
    public void profileAppendById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_append", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_append"));
    }

    @Override
    public void profileUnsetById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_unset", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_unset"));
    }

    @Override
    public void flush() {
        this.worker.flush();
    }

    @Override
    public void shutdown() {
        this.worker.shutdown();
    }

    private void dealProfile(UserRecord userRecord, String actionType) throws InvalidArgumentException {
        this.addEvent(userRecord.getDistinctId(), userRecord.getIsLoginId(), null, actionType, null, userRecord.getPropertyMap());
    }

    private void addItem(String itemType, String itemId, String actionType, Map<String, Object> properties) throws InvalidArgumentException {
        SensorsAnalyticsUtil.assertKey(ITEM_TYPE, itemType);
        SensorsAnalyticsUtil.assertValue(ITEM_ID, itemId);
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        this.worker.doAddItem(itemType, itemId, actionType, properties);
    }

    private void addEvent(String distinctId, boolean isLoginId, String originDistinctId, String actionType, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        SensorsAnalyticsUtil.assertValue(DISTINCT_ID, distinctId);
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        if (actionType.equals("track")) {
            SensorsAnalyticsUtil.assertKey(EVENT_NAME, eventName);
        } else if (actionType.equals("track_signup")) {
            SensorsAnalyticsUtil.assertValue(ORIGINAL_DISTINCT_ID, originDistinctId);
        }
        this.worker.doAddEvent(distinctId, isLoginId, originDistinctId, actionType, eventName, properties);
    }

    private void addEventIdentity(SensorsAnalyticsIdentity analyticsIdentity, String actionType, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEventIdentity(analyticsIdentity.getIdentityMap(), actionType, eventName, properties);
    }

    private void addEventIdentity(Map<String, String> identityMap, String actionType, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        if (identityMap.isEmpty()) {
            throw new InvalidArgumentException("The identity is empty.");
        }
        this.assertIdentityMap(actionType, identityMap);
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        if (actionType.equals("track")) {
            SensorsAnalyticsUtil.assertKey(EVENT_NAME, eventName);
        }
        this.worker.doAddEventIdentity(identityMap, actionType, eventName, properties);
    }

    private void assertIdentityMap(String actionType, Map<String, String> identityMap) throws InvalidArgumentException {
        for (Map.Entry<String, String> entry : identityMap.entrySet()) {
            SensorsAnalyticsUtil.assertKey(actionType, entry.getKey());
            SensorsAnalyticsUtil.assertValue(actionType, entry.getValue());
        }
    }
}

