/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.PersonalAccessToken;
import org.gitlab4j.api.utils.ISO8601;

public class PersonalAccessTokenApi
extends AbstractApi {
    public PersonalAccessTokenApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public PersonalAccessToken rotatePersonalAccessToken() throws GitLabApiException {
        return this.rotatePersonalAccessToken(null);
    }

    public PersonalAccessToken rotatePersonalAccessToken(Date expiresAt) throws GitLabApiException {
        return this.rotatePersonalAccessToken("self", expiresAt);
    }

    public PersonalAccessToken rotatePersonalAccessToken(String id, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("expires_at", ISO8601.dateOnly(expiresAt));
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"personal_access_tokens", id, "rotate"});
        return (PersonalAccessToken)response.readEntity(PersonalAccessToken.class);
    }
}

