/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Environment;

public class EnvironmentsApi
extends AbstractApi {
    public EnvironmentsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Environment> getEnvironments(Object projectIdOrPath) throws GitLabApiException {
        return this.getEnvironments(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Stream<Environment> getEnvironmentsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getEnvironments(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Pager<Environment> getEnvironments(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Environment>(this, Environment.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments");
    }

    public Environment getEnvironment(Object projectIdOrPath, Long environmentId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId);
        return (Environment)response.readEntity(Environment.class);
    }

    public Optional<Environment> getOptionalEnvironment(Object projectIdOrPath, Long environmentId) {
        try {
            return Optional.ofNullable(this.getEnvironment(projectIdOrPath, environmentId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    @Deprecated
    public Environment createEnvironment(Object projectIdOrPath, String name, String externalUrl) throws GitLabApiException {
        return this.createEnvironment(projectIdOrPath, name, externalUrl, null);
    }

    public Environment createEnvironment(Object projectIdOrPath, String name, String externalUrl, String tier) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("external_url", externalUrl).withParam("tier", tier);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "environments"});
        return (Environment)response.readEntity(Environment.class);
    }

    @Deprecated
    public Environment updateEnvironment(Object projectIdOrPath, Long environmentId, String name, String externalUrl) throws GitLabApiException {
        return this.updateEnvironment(projectIdOrPath, environmentId, name, externalUrl, null);
    }

    public Environment updateEnvironment(Object projectIdOrPath, Long environmentId, String name, String externalUrl, String tier) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("external_url", externalUrl).withParam("tier", tier);
        Response response = this.putWithFormData(Response.Status.OK, formData, new Object[]{formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId});
        return (Environment)response.readEntity(Environment.class);
    }

    public Environment stopEnvironment(Object projectIdOrPath, Long environmentId) throws GitLabApiException {
        Response response = this.post(Response.Status.OK, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId, "stop"});
        return (Environment)response.readEntity(Environment.class);
    }

    public void deleteEnvironment(Object projectIdOrPath, Long environmentId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId);
    }

    public Environment createEnvironment(Object projectIdOrPath, Long environmentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId, "stop"});
        return (Environment)response.readEntity(Environment.class);
    }
}

